/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.DuplexConnectionPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ProcessorUtils;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import java.io.IOException;
import java.util.Map;

public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }
}

