/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class SettableAnyProperty
implements Serializable {
    protected final BeanProperty _property;
    protected final AnnotatedMember _setter;
    final boolean _setterIsField;
    protected final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final KeyDeserializer _keyDeserializer;

    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this._property = beanProperty;
        this._setter = annotatedMember;
        this._type = javaType;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._keyDeserializer = keyDeserializer;
        this._setterIsField = annotatedMember instanceof AnnotatedField;
    }

    public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
        return new SettableAnyProperty(this._property, this._setter, this._type, this._keyDeserializer, jsonDeserializer, this._valueTypeDeserializer);
    }

    public void fixAccess(DeserializationConfig deserializationConfig) {
        this._setter.fixAccess(deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public BeanProperty getProperty() {
        return this._property;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public JavaType getType() {
        return this._type;
    }

    public final void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException {
        try {
            String string2 = this._keyDeserializer == null ? string : this._keyDeserializer.deserializeKey(string, deserializationContext);
            this.set(object, string2, this.deserialize(jsonParser, deserializationContext));
        }
        catch (UnresolvedForwardReference unresolvedForwardReference) {
            if (this._valueDeserializer.getObjectIdReader() == null) {
                throw JsonMappingException.from(jsonParser, "Unresolved forward reference but no identity info.", (Throwable)unresolvedForwardReference);
            }
            AnySetterReferring anySetterReferring = new AnySetterReferring(this, unresolvedForwardReference, this._type.getRawClass(), object, string);
            unresolvedForwardReference.getRoid().appendReferring(anySetterReferring);
        }
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return this._valueDeserializer.getNullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
    }

    public void set(Object object, Object object2, Object object3) throws IOException {
        try {
            if (this._setterIsField) {
                AnnotatedField annotatedField = (AnnotatedField)this._setter;
                Map map = (Map)annotatedField.getValue(object);
                if (map != null) {
                    map.put(object2, object3);
                }
            } else {
                ((AnnotatedMethod)this._setter).callOnWith(object, object2, object3);
            }
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2, object3);
        }
    }

    protected void _throwAsIOE(Exception exception, Object object, Object object2) throws IOException {
        if (exception instanceof IllegalArgumentException) {
            String string = ClassUtil.classNameOf(object2);
            StringBuilder stringBuilder = new StringBuilder("Problem deserializing \"any\" property '").append(object);
            stringBuilder.append("' of class " + this.getClassName() + " (expected type: ").append(this._type);
            stringBuilder.append("; actual type: ").append(string).append(")");
            String string2 = ClassUtil.exceptionMessage(exception);
            if (string2 != null) {
                stringBuilder.append(", problem: ").append(string2);
            } else {
                stringBuilder.append(" (no error message provided)");
            }
            throw new JsonMappingException(null, stringBuilder.toString(), (Throwable)exception);
        }
        ClassUtil.throwIfIOE(exception);
        ClassUtil.throwIfRTE(exception);
        Throwable throwable = ClassUtil.getRootCause(exception);
        throw new JsonMappingException(null, ClassUtil.exceptionMessage(throwable), throwable);
    }

    private String getClassName() {
        return this._setter.getDeclaringClass().getName();
    }

    public String toString() {
        return "[any property on class " + this.getClassName() + "]";
    }

    private static class AnySetterReferring
    extends ReadableObjectId.Referring {
        private final SettableAnyProperty _parent;
        private final Object _pojo;
        private final String _propName;

        public AnySetterReferring(SettableAnyProperty settableAnyProperty, UnresolvedForwardReference unresolvedForwardReference, Class<?> clazz, Object object, String string) {
            super(unresolvedForwardReference, clazz);
            this._parent = settableAnyProperty;
            this._pojo = object;
            this._propName = string;
        }

        @Override
        public void handleResolvedForwardReference(Object object, Object object2) throws IOException {
            if (!this.hasId(object)) {
                throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + object.toString() + "] that wasn't previously registered.");
            }
            this._parent.set(this._pojo, this._propName, object2);
        }
    }
}

