/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectCollectors;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Hashing;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableEnumSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.JdkBackedImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableAsList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SingletonImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collector;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private transient ImmutableList<E> asList;

    public static <E> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
        return CollectCollectors.toImmutableSet();
    }

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E e2) {
        return new SingletonImmutableSet<E>(e2);
    }

    public static <E> ImmutableSet<E> of(E e2, E e3) {
        return ImmutableSet.construct(2, 2, e2, e3);
    }

    public static <E> ImmutableSet<E> of(E e2, E e3, E e4) {
        return ImmutableSet.construct(3, 3, e2, e3, e4);
    }

    public static <E> ImmutableSet<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableSet.construct(4, 4, e2, e3, e4, e5);
    }

    public static <E> ImmutableSet<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableSet.construct(5, 5, e2, e3, e4, e5, e6);
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E ... EArray) {
        Preconditions.checkArgument(EArray.length <= 0x7FFFFFF9, "the total number of elements must fit in an int");
        int n2 = 6;
        Object[] objectArray = new Object[6 + EArray.length];
        objectArray[0] = e2;
        objectArray[1] = e3;
        objectArray[2] = e4;
        objectArray[3] = e5;
        objectArray[4] = e6;
        objectArray[5] = e7;
        System.arraycopy(EArray, 0, objectArray, 6, EArray.length);
        return ImmutableSet.construct(objectArray.length, objectArray.length, objectArray);
    }

    private static <E> ImmutableSet<E> constructUnknownDuplication(int n2, Object ... objectArray) {
        return ImmutableSet.construct(n2, Math.max(4, IntMath.sqrt(n2, RoundingMode.CEILING)), objectArray);
    }

    private static <E> ImmutableSet<E> construct(int n2, int n3, Object ... objectArray) {
        switch (n2) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object object = objectArray[0];
                return ImmutableSet.of(object);
            }
        }
        SetBuilderImpl setBuilderImpl = new RegularSetBuilderImpl<Object>(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = Preconditions.checkNotNull(objectArray[i2]);
            setBuilderImpl = ((SetBuilderImpl)setBuilderImpl).add(object);
        }
        return ((SetBuilderImpl)setBuilderImpl).review().build();
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> collection) {
        Object[] objectArray;
        if (collection instanceof ImmutableSet && !(collection instanceof SortedSet)) {
            objectArray = (Object[])collection;
            if (!objectArray.isPartialView()) {
                return objectArray;
            }
        } else if (collection instanceof EnumSet) {
            return ImmutableSet.copyOfEnumSet((EnumSet)collection);
        }
        objectArray = collection.toArray();
        if (collection instanceof Set) {
            return ImmutableSet.construct(objectArray.length, objectArray.length, objectArray);
        }
        return ImmutableSet.constructUnknownDuplication(objectArray.length, objectArray);
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> iterable) {
        return iterable instanceof Collection ? ImmutableSet.copyOf((Collection)iterable) : ImmutableSet.copyOf(iterable.iterator());
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return ImmutableSet.of();
        }
        E e2 = iterator.next();
        if (!iterator.hasNext()) {
            return ImmutableSet.of(e2);
        }
        return ((Builder)((Builder)new Builder().add((Object)e2)).addAll(iterator)).build();
    }

    public static <E> ImmutableSet<E> copyOf(E[] EArray) {
        switch (EArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(EArray[0]);
            }
        }
        return ImmutableSet.constructUnknownDuplication(EArray.length, (Object[])EArray.clone());
    }

    private static ImmutableSet copyOfEnumSet(EnumSet enumSet) {
        return ImmutableEnumSet.asImmutable(EnumSet.copyOf(enumSet));
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableList<E> asList() {
        ImmutableList<E> immutableList = this.asList;
        return immutableList == null ? (this.asList = this.createAsList()) : immutableList;
    }

    ImmutableList<E> createAsList() {
        return new RegularImmutableAsList(this, this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    static Object[] rebuildHashTable(int n2, Object[] objectArray, int n3) {
        Object[] objectArray2 = new Object[n2];
        int n4 = objectArray2.length - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            Object object = objectArray[i2];
            int n6 = n5 = Hashing.smear(object.hashCode());
            while (true) {
                int n7;
                if (objectArray2[n7 = n6 & n4] == null) break;
                ++n6;
            }
            objectArray2[n7] = object;
        }
        return objectArray2;
    }

    static int chooseTableSize(int n2) {
        if ((n2 = Math.max(n2, 2)) < 0x2CCCCCCC) {
            int n3 = Integer.highestOneBit(n2 - 1) << 1;
            while ((double)n3 * 0.7 < (double)n2) {
                n3 <<= 1;
            }
            return n3;
        }
        Preconditions.checkArgument(n2 < 0x40000000, "collection too large");
        return 0x40000000;
    }

    static boolean hashFloodingDetected(Object[] objectArray) {
        int n2;
        int n3 = ImmutableSet.maxRunBeforeFallback(objectArray.length);
        int n4 = 0;
        while (n4 < objectArray.length && objectArray[n4] != null) {
            if (++n4 <= n3) continue;
            return true;
        }
        for (n2 = objectArray.length - 1; n2 > n4 && objectArray[n2] != null; --n2) {
            if (n4 + (objectArray.length - 1 - n2) <= n3) continue;
            return true;
        }
        int n5 = n3 / 2;
        int n6 = n4 + 1;
        while (n6 + n5 <= n2) {
            block5: {
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (objectArray[n6 + i2] != null) {
                        continue;
                    }
                    break block5;
                }
                return true;
            }
            n6 += n5;
        }
        return false;
    }

    private static int maxRunBeforeFallback(int n2) {
        return 13 * IntMath.log2(n2, RoundingMode.UNNECESSARY);
    }

    private static final class JdkBackedSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private final Set<Object> delegate;

        JdkBackedSetBuilderImpl(SetBuilderImpl<E> setBuilderImpl) {
            super(setBuilderImpl);
            this.delegate = Sets.newHashSetWithExpectedSize(this.distinct);
            for (int i2 = 0; i2 < this.distinct; ++i2) {
                this.delegate.add(this.dedupedElements[i2]);
            }
        }

        @Override
        SetBuilderImpl<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            if (this.delegate.add(e2)) {
                this.addDedupedElement(e2);
            }
            return this;
        }

        @Override
        SetBuilderImpl<E> copy() {
            return new JdkBackedSetBuilderImpl<E>(this);
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(this.dedupedElements[0]);
                }
            }
            return new JdkBackedImmutableSet(this.delegate, ImmutableList.asImmutableList(this.dedupedElements, this.distinct));
        }
    }

    private static final class RegularSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private Object[] hashTable;
        private int maxRunBeforeFallback;
        private int expandTableThreshold;
        private int hashCode;

        RegularSetBuilderImpl(int n2) {
            super(n2);
            int n3 = ImmutableSet.chooseTableSize(n2);
            this.hashTable = new Object[n3];
            this.maxRunBeforeFallback = ImmutableSet.maxRunBeforeFallback(n3);
            this.expandTableThreshold = (int)(0.7 * (double)n3);
        }

        RegularSetBuilderImpl(RegularSetBuilderImpl<E> regularSetBuilderImpl) {
            super(regularSetBuilderImpl);
            this.hashTable = Arrays.copyOf(regularSetBuilderImpl.hashTable, regularSetBuilderImpl.hashTable.length);
            this.maxRunBeforeFallback = regularSetBuilderImpl.maxRunBeforeFallback;
            this.expandTableThreshold = regularSetBuilderImpl.expandTableThreshold;
            this.hashCode = regularSetBuilderImpl.hashCode;
        }

        void ensureTableCapacity(int n2) {
            if (n2 > this.expandTableThreshold && this.hashTable.length < 0x40000000) {
                int n3 = this.hashTable.length * 2;
                this.hashTable = ImmutableSet.rebuildHashTable(n3, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = ImmutableSet.maxRunBeforeFallback(n3);
                this.expandTableThreshold = (int)(0.7 * (double)n3);
            }
        }

        @Override
        SetBuilderImpl<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            int n2 = e2.hashCode();
            int n3 = Hashing.smear(n2);
            int n4 = this.hashTable.length - 1;
            int n5 = n3;
            while (n5 - n3 < this.maxRunBeforeFallback) {
                int n6 = n5 & n4;
                Object object = this.hashTable[n6];
                if (object == null) {
                    this.addDedupedElement(e2);
                    this.hashTable[n6] = e2;
                    this.hashCode += n2;
                    this.ensureTableCapacity(this.distinct);
                    return this;
                }
                if (object.equals(e2)) {
                    return this;
                }
                ++n5;
            }
            return new JdkBackedSetBuilderImpl<E>(this).add(e2);
        }

        @Override
        SetBuilderImpl<E> copy() {
            return new RegularSetBuilderImpl<E>(this);
        }

        @Override
        SetBuilderImpl<E> review() {
            int n2 = ImmutableSet.chooseTableSize(this.distinct);
            if (n2 * 2 < this.hashTable.length) {
                this.hashTable = ImmutableSet.rebuildHashTable(n2, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = ImmutableSet.maxRunBeforeFallback(n2);
                this.expandTableThreshold = (int)(0.7 * (double)n2);
            }
            return ImmutableSet.hashFloodingDetected(this.hashTable) ? new JdkBackedSetBuilderImpl(this) : this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(this.dedupedElements[0]);
                }
            }
            Object[] objectArray = this.distinct == this.dedupedElements.length ? this.dedupedElements : Arrays.copyOf(this.dedupedElements, this.distinct);
            return new RegularImmutableSet(objectArray, this.hashCode, this.hashTable, this.hashTable.length - 1);
        }
    }

    private static abstract class SetBuilderImpl<E> {
        E[] dedupedElements;
        int distinct;

        SetBuilderImpl(int n2) {
            this.dedupedElements = new Object[n2];
            this.distinct = 0;
        }

        SetBuilderImpl(SetBuilderImpl<E> setBuilderImpl) {
            this.dedupedElements = Arrays.copyOf(setBuilderImpl.dedupedElements, setBuilderImpl.dedupedElements.length);
            this.distinct = setBuilderImpl.distinct;
        }

        private void ensureCapacity(int n2) {
            if (n2 > this.dedupedElements.length) {
                int n3 = ImmutableCollection.Builder.expandedCapacity(this.dedupedElements.length, n2);
                this.dedupedElements = Arrays.copyOf(this.dedupedElements, n3);
            }
        }

        final void addDedupedElement(E e2) {
            this.ensureCapacity(this.distinct + 1);
            this.dedupedElements[this.distinct++] = e2;
        }

        abstract SetBuilderImpl<E> add(E var1);

        final SetBuilderImpl<E> combine(SetBuilderImpl<E> setBuilderImpl) {
            SetBuilderImpl<E> setBuilderImpl2 = this;
            for (int i2 = 0; i2 < setBuilderImpl.distinct; ++i2) {
                setBuilderImpl2 = setBuilderImpl2.add(setBuilderImpl.dedupedElements[i2]);
            }
            return setBuilderImpl2;
        }

        abstract SetBuilderImpl<E> copy();

        SetBuilderImpl<E> review() {
            return this;
        }

        abstract ImmutableSet<E> build();
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        private SetBuilderImpl<E> impl;
        boolean forceCopy;

        public Builder() {
            this(4);
        }

        Builder(int n2) {
            this.impl = new RegularSetBuilderImpl(n2);
        }

        Builder(boolean bl2) {
            this.impl = null;
        }

        final void copyIfNecessary() {
            if (this.forceCopy) {
                this.copy();
                this.forceCopy = false;
            }
        }

        void copy() {
            this.impl = this.impl.copy();
        }

        @Override
        public Builder<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            this.copyIfNecessary();
            this.impl = this.impl.add(e2);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll(iterable);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll(iterator);
            return this;
        }

        Builder<E> combine(Builder<E> builder) {
            this.copyIfNecessary();
            this.impl = this.impl.combine(builder.impl);
            return this;
        }

        public ImmutableSet<E> build() {
            this.forceCopy = true;
            this.impl = this.impl.review();
            return this.impl.build();
        }
    }
}

