/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.BridgeMethodResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.MethodExecutor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.MethodFilter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.MethodResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectionHelper;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectiveMethodExecutor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectiveMethodResolver
implements MethodResolver {
    private final boolean useDistance;
    private Map<Class<?>, MethodFilter> filters;

    public ReflectiveMethodResolver() {
        this.useDistance = true;
    }

    @Override
    public MethodExecutor resolve(EvaluationContext evaluationContext, Object object, String string, List<TypeDescriptor> list) throws AccessException {
        try {
            MethodFilter methodFilter;
            TypeConverter typeConverter = evaluationContext.getTypeConverter();
            Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
            ArrayList<Object> arrayList = new ArrayList(this.getMethods(clazz, object));
            MethodFilter methodFilter2 = methodFilter = this.filters != null ? this.filters.get(clazz) : null;
            if (methodFilter != null) {
                List<Method> list2 = methodFilter.filter(arrayList);
                ArrayList<Object> arrayList2 = arrayList = list2 instanceof ArrayList ? (ArrayList<Object>)list2 : new ArrayList<Method>(list2);
            }
            if (arrayList.size() > 1) {
                arrayList.sort((method, method2) -> {
                    int n2;
                    int n3 = method.getParameterCount();
                    if (n3 == (n2 = method2.getParameterCount())) {
                        if (!method.isVarArgs() && method2.isVarArgs()) {
                            return -1;
                        }
                        if (method.isVarArgs() && !method2.isVarArgs()) {
                            return 1;
                        }
                        return 0;
                    }
                    return Integer.compare(n3, n2);
                });
            }
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                arrayList.set(i2, BridgeMethodResolver.findBridgedMethod((Method)arrayList.get(i2)));
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(arrayList);
            Method method3 = null;
            int n2 = Integer.MAX_VALUE;
            Method method4 = null;
            boolean bl2 = false;
            for (Method method5 : linkedHashSet) {
                if (!method5.getName().equals(string)) continue;
                int n3 = method5.getParameterCount();
                ArrayList<TypeDescriptor> arrayList3 = new ArrayList<TypeDescriptor>(n3);
                for (int i3 = 0; i3 < n3; ++i3) {
                    arrayList3.add(new TypeDescriptor(new MethodParameter(method5, i3)));
                }
                ReflectionHelper.ArgumentsMatchInfo argumentsMatchInfo = null;
                if (method5.isVarArgs() && list.size() >= n3 - 1) {
                    argumentsMatchInfo = ReflectionHelper.compareArgumentsVarargs(arrayList3, list, typeConverter);
                } else if (n3 == list.size()) {
                    argumentsMatchInfo = ReflectionHelper.compareArguments(arrayList3, list, typeConverter);
                }
                if (argumentsMatchInfo == null) continue;
                if (argumentsMatchInfo.isExactMatch()) {
                    return new ReflectiveMethodExecutor(method5, clazz);
                }
                if (argumentsMatchInfo.isCloseMatch()) {
                    if (this.useDistance) {
                        int n4 = ReflectionHelper.getTypeDifferenceWeight(arrayList3, list);
                        if (method3 != null && n4 >= n2) continue;
                        method3 = method5;
                        n2 = n4;
                        continue;
                    }
                    if (method3 != null) continue;
                    method3 = method5;
                    continue;
                }
                if (!argumentsMatchInfo.isMatchRequiringConversion()) continue;
                if (method4 != null) {
                    bl2 = true;
                }
                method4 = method5;
            }
            if (method3 != null) {
                return new ReflectiveMethodExecutor(method3, clazz);
            }
            if (method4 != null) {
                if (bl2) {
                    throw new SpelEvaluationException(SpelMessage.MULTIPLE_POSSIBLE_METHODS, string);
                }
                return new ReflectiveMethodExecutor(method4, clazz);
            }
            return null;
        }
        catch (EvaluationException evaluationException) {
            throw new AccessException("Failed to resolve method", evaluationException);
        }
    }

    private Set<Method> getMethods(Class<?> clazz, Object object) {
        Method[] methodArray;
        if (object instanceof Class) {
            Method[] methodArray2;
            LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
            for (Method method : methodArray2 = this.getMethods(clazz)) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                linkedHashSet.add(method);
            }
            Collections.addAll(linkedHashSet, this.getMethods(Class.class));
            return linkedHashSet;
        }
        if (Proxy.isProxyClass(clazz)) {
            LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                Method[] methodArray3;
                for (Method method : methodArray3 = this.getMethods(clazz2)) {
                    if (!this.isCandidateForInvocation(method, clazz)) continue;
                    linkedHashSet.add(method);
                }
            }
            return linkedHashSet;
        }
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        for (Method method : methodArray = this.getMethods(clazz)) {
            if (!this.isCandidateForInvocation(method, clazz)) continue;
            linkedHashSet.add(method);
        }
        return linkedHashSet;
    }

    protected Method[] getMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    protected boolean isCandidateForInvocation(Method method, Class<?> clazz) {
        return true;
    }
}

