/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.NotNull;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.AsmCachedFieldFactory;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializerAnnotationsUtil;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializerConfig;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializerGenericsUtil;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializerUnsafeUtil;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.Generics;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.ObjectCachedFieldFactory;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.ObjectField;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.IntArray;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.ObjectMap;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.Util;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.minlog.Log;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.reflectasm.FieldAccess;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class FieldSerializer<T>
extends Serializer<T>
implements Comparator<CachedField> {
    final Kryo kryo;
    final Class type;
    final TypeVariable[] typeParameters;
    final Class componentType;
    protected final FieldSerializerConfig config;
    private CachedField[] fields = new CachedField[0];
    private CachedField[] transientFields = new CachedField[0];
    protected HashSet<CachedField> removedFields = new HashSet();
    Object access;
    private FieldSerializerUnsafeUtil unsafeUtil;
    private FieldSerializerGenericsUtil genericsUtil;
    private FieldSerializerAnnotationsUtil annotationsUtil;
    private Class[] generics;
    private Generics genericsScope;
    private boolean varIntsEnabled = true;
    private boolean useMemRegions = false;
    private boolean hasObjectFields = false;
    static CachedFieldFactory asmFieldFactory;
    static CachedFieldFactory objectFieldFactory;
    static CachedFieldFactory unsafeFieldFactory;
    static boolean unsafeAvailable;
    static Class<?> unsafeUtilClass;
    static Method sortFieldsByOffsetMethod;

    public FieldSerializer(Kryo kryo, Class clazz) {
        this(kryo, clazz, null);
    }

    public FieldSerializer(Kryo kryo, Class clazz, Class[] classArray) {
        this(kryo, clazz, classArray, kryo.getFieldSerializerConfig().clone());
    }

    protected FieldSerializer(Kryo kryo, Class clazz, Class[] classArray, FieldSerializerConfig fieldSerializerConfig) {
        if (Log.TRACE) {
            Log.trace("kryo", "Optimize ints: " + this.varIntsEnabled);
        }
        this.config = fieldSerializerConfig;
        this.kryo = kryo;
        this.type = clazz;
        this.generics = classArray;
        this.typeParameters = clazz.getTypeParameters();
        this.componentType = this.typeParameters == null || this.typeParameters.length == 0 ? clazz.getComponentType() : null;
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = FieldSerializerUnsafeUtil.Factory.getInstance(this);
        this.annotationsUtil = new FieldSerializerAnnotationsUtil(this);
        this.rebuildCachedFields();
    }

    protected void rebuildCachedFields() {
        this.rebuildCachedFields(false);
    }

    protected void rebuildCachedFields(boolean bl2) {
        List<Field> list;
        Serializable serializable;
        List<Field> list2;
        List<Field> list3;
        if (Log.TRACE && this.generics != null) {
            Log.trace("kryo", "Generic type parameters: " + Arrays.toString(this.generics));
        }
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        this.hasObjectFields = false;
        if (this.config.isOptimizedGenerics()) {
            list3 = this.genericsUtil.buildGenericsScope(this.type, this.generics);
            this.genericsScope = list3;
            if (this.genericsScope != null) {
                this.kryo.getGenericsResolver().pushScope(this.type, this.genericsScope);
            }
        }
        IntArray intArray = new IntArray();
        if (!bl2) {
            Object object;
            list2 = new ArrayList<Field>();
            for (serializable = this.type; serializable != Object.class; serializable = ((Class)serializable).getSuperclass()) {
                object = ((Class)serializable).getDeclaredFields();
                if (object == null) continue;
                for (Field field : object) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    list2.add(field);
                }
            }
            object = this.kryo.getContext();
            if (this.useMemRegions && !this.config.isUseAsm() && unsafeAvailable) {
                try {
                    Field[] exception = (Field[])sortFieldsByOffsetMethod.invoke(null, list2);
                    list2 = Arrays.asList(exception);
                }
                catch (Exception runtimeException) {
                    throw new RuntimeException("Cannot invoke UnsafeUtil.sortFieldsByOffset()", runtimeException);
                }
            }
            list3 = this.buildValidFields(false, list2, (ObjectMap)object, intArray);
            list = this.buildValidFields(true, list2, (ObjectMap)object, intArray);
            if (this.config.isUseAsm() && !Util.IS_ANDROID && Modifier.isPublic(this.type.getModifiers()) && intArray.indexOf(1) != -1) {
                try {
                    this.access = FieldAccess.get(this.type);
                }
                catch (RuntimeException runtimeException) {}
            }
        } else {
            list3 = this.buildValidFieldsFromCachedFields(this.fields, intArray);
            list = this.buildValidFieldsFromCachedFields(this.transientFields, intArray);
        }
        list2 = new ArrayList(list3.size());
        serializable = new ArrayList(list.size());
        this.createCachedFields(intArray, list3, list2, 0);
        this.createCachedFields(intArray, list, (List<CachedField>)((Object)serializable), list3.size());
        Collections.sort(list2, this);
        this.fields = list2.toArray(new CachedField[list2.size()]);
        Collections.sort(serializable, this);
        this.transientFields = serializable.toArray(new CachedField[serializable.size()]);
        this.initializeCachedFields();
        if (this.genericsScope != null) {
            this.kryo.getGenericsResolver().popScope();
        }
        if (!bl2) {
            for (CachedField cachedField : this.removedFields) {
                this.removeField(cachedField);
            }
        }
        this.annotationsUtil.processAnnotatedFields(this);
    }

    private List<Field> buildValidFieldsFromCachedFields(CachedField[] cachedFieldArray, IntArray intArray) {
        ArrayList<Field> arrayList = new ArrayList<Field>(cachedFieldArray.length);
        for (CachedField cachedField : cachedFieldArray) {
            arrayList.add(cachedField.field);
            intArray.add(cachedField.accessIndex > -1 ? 1 : 0);
        }
        return arrayList;
    }

    private List<Field> buildValidFields(boolean bl2, List<Field> list, ObjectMap objectMap, IntArray intArray) {
        ArrayList<Field> arrayList = new ArrayList<Field>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Optional optional;
            Field field = list.get(i2);
            int n3 = field.getModifiers();
            if (Modifier.isTransient(n3) != bl2 || Modifier.isStatic(n3) || field.isSynthetic() && this.config.isIgnoreSyntheticFields()) continue;
            if (!field.isAccessible()) {
                if (!this.config.isSetFieldsAsAccessible()) continue;
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException accessControlException) {
                    continue;
                }
            }
            if ((optional = field.getAnnotation(Optional.class)) != null && !objectMap.containsKey(optional.value())) continue;
            arrayList.add(field);
            intArray.add(!Modifier.isFinal(n3) && Modifier.isPublic(n3) && Modifier.isPublic(field.getType().getModifiers()) ? 1 : 0);
        }
        return arrayList;
    }

    private void createCachedFields(IntArray intArray, List<Field> list, List<CachedField> list2, int n2) {
        if (this.config.isUseAsm() || !this.useMemRegions) {
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Field field = list.get(i2);
                int n4 = -1;
                if (this.access != null && intArray.get(n2 + i2) == 1) {
                    n4 = ((FieldAccess)this.access).getIndex(field.getName());
                }
                list2.add(this.newCachedField(field, list2.size(), n4));
            }
        } else {
            this.unsafeUtil.createUnsafeCacheFieldsAndRegions(list, list2, n2, intArray);
        }
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] classArray) {
        if (!this.config.isOptimizedGenerics()) {
            return;
        }
        this.generics = classArray;
        if (this.typeParameters != null && this.typeParameters.length > 0) {
            this.rebuildCachedFields(true);
        }
    }

    public Class[] getGenerics() {
        return this.generics;
    }

    protected void initializeCachedFields() {
    }

    CachedField newCachedField(Field field, int n2, int n3) {
        CachedField cachedField;
        Type type;
        Class[] classArray = new Class[]{field.getType()};
        Type type2 = type = this.config.isOptimizedGenerics() ? field.getGenericType() : null;
        if (!this.config.isOptimizedGenerics() || type == classArray[0]) {
            if (Log.TRACE) {
                Log.trace("kryo", "Field " + field.getName() + ": " + classArray[0]);
            }
            cachedField = this.newMatchingCachedField(field, n3, classArray[0], type, null);
        } else {
            cachedField = this.genericsUtil.newCachedFieldOfGenericType(field, n3, classArray, type);
        }
        if (cachedField instanceof ObjectField) {
            this.hasObjectFields = true;
        }
        cachedField.field = field;
        cachedField.varIntsEnabled = this.varIntsEnabled;
        if (!this.config.isUseAsm()) {
            cachedField.offset = this.unsafeUtil.getObjectFieldOffset(field);
        }
        cachedField.access = (FieldAccess)this.access;
        cachedField.accessIndex = n3;
        boolean bl2 = cachedField.canBeNull = this.config.isFieldsCanBeNull() && !classArray[0].isPrimitive() && !field.isAnnotationPresent(NotNull.class);
        if (this.kryo.isFinal(classArray[0]) || this.config.isFixedFieldTypes()) {
            cachedField.valueClass = classArray[0];
        }
        return cachedField;
    }

    CachedField newMatchingCachedField(Field field, int n2, Class clazz, Type type, Class[] classArray) {
        CachedField cachedField;
        if (n2 != -1) {
            cachedField = this.getAsmFieldFactory().createCachedField(clazz, field, this);
        } else if (!this.config.isUseAsm()) {
            cachedField = this.getUnsafeFieldFactory().createCachedField(clazz, field, this);
        } else {
            cachedField = this.getObjectFieldFactory().createCachedField(clazz, field, this);
            if (this.config.isOptimizedGenerics()) {
                if (classArray != null) {
                    ((ObjectField)cachedField).generics = classArray;
                } else if (type != null) {
                    Object[] objectArray = FieldSerializerGenericsUtil.getGenerics(type, this.kryo);
                    ((ObjectField)cachedField).generics = objectArray;
                    if (Log.TRACE) {
                        Log.trace("kryo", "Field generics: " + Arrays.toString(objectArray));
                    }
                }
            }
        }
        return cachedField;
    }

    private CachedFieldFactory getAsmFieldFactory() {
        if (asmFieldFactory == null) {
            asmFieldFactory = new AsmCachedFieldFactory();
        }
        return asmFieldFactory;
    }

    private CachedFieldFactory getObjectFieldFactory() {
        if (objectFieldFactory == null) {
            objectFieldFactory = new ObjectCachedFieldFactory();
        }
        return objectFieldFactory;
    }

    private CachedFieldFactory getUnsafeFieldFactory() {
        if (unsafeFieldFactory == null) {
            try {
                unsafeFieldFactory = (CachedFieldFactory)this.getClass().getClassLoader().loadClass("com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.UnsafeCachedFieldFactory").newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot create UnsafeFieldFactory", exception);
            }
        }
        return unsafeFieldFactory;
    }

    @Override
    public int compare(CachedField cachedField, CachedField cachedField2) {
        return this.getCachedFieldName(cachedField).compareTo(this.getCachedFieldName(cachedField2));
    }

    public void setFieldsCanBeNull(boolean bl2) {
        this.config.setFieldsCanBeNull(bl2);
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean bl2) {
        this.config.setFieldsAsAccessible(bl2);
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean bl2) {
        this.config.setIgnoreSyntheticFields(bl2);
        this.rebuildCachedFields();
    }

    public void setFixedFieldTypes(boolean bl2) {
        this.config.setFixedFieldTypes(bl2);
        this.rebuildCachedFields();
    }

    public void setUseAsm(boolean bl2) {
        this.config.setUseAsm(bl2);
        this.rebuildCachedFields();
    }

    public void setCopyTransient(boolean bl2) {
        this.config.setCopyTransient(bl2);
    }

    public void setSerializeTransient(boolean bl2) {
        this.config.setSerializeTransient(bl2);
    }

    public void setOptimizedGenerics(boolean bl2) {
        this.config.setOptimizedGenerics(bl2);
        this.rebuildCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T t2) {
        int n2;
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer.write fields of class: " + t2.getClass().getName());
        }
        if (this.config.isOptimizedGenerics()) {
            if (this.typeParameters != null && this.generics != null) {
                this.rebuildCachedFields();
            }
            if (this.genericsScope != null) {
                kryo.getGenericsResolver().pushScope(this.type, this.genericsScope);
            }
        }
        CachedField[] cachedFieldArray = this.fields;
        int n3 = cachedFieldArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            cachedFieldArray[n2].write(output, t2);
        }
        if (this.config.isSerializeTransient()) {
            n3 = this.transientFields.length;
            for (n2 = 0; n2 < n3; ++n2) {
                this.transientFields[n2].write(output, t2);
            }
        }
        if (this.config.isOptimizedGenerics() && this.genericsScope != null) {
            kryo.getGenericsResolver().popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Kryo kryo, Input input, Class<T> clazz) {
        try {
            int n2;
            if (this.config.isOptimizedGenerics()) {
                if (this.typeParameters != null && this.generics != null) {
                    this.rebuildCachedFields();
                }
                if (this.genericsScope != null) {
                    kryo.getGenericsResolver().pushScope(clazz, this.genericsScope);
                }
            }
            T t2 = this.create(kryo, input, clazz);
            kryo.reference(t2);
            CachedField[] cachedFieldArray = this.fields;
            int n3 = cachedFieldArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                cachedFieldArray[n2].read(input, t2);
            }
            if (this.config.isSerializeTransient()) {
                n3 = this.transientFields.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.transientFields[n2].read(input, t2);
                }
            }
            T t3 = t2;
            return t3;
        }
        finally {
            if (this.config.isOptimizedGenerics() && this.genericsScope != null && kryo.getGenericsResolver() != null) {
                kryo.getGenericsResolver().popScope();
            }
        }
    }

    protected T create(Kryo kryo, Input input, Class<T> clazz) {
        return kryo.newInstance(clazz);
    }

    public CachedField getField(String string) {
        for (CachedField cachedField : this.fields) {
            if (!this.getCachedFieldName(cachedField).equals(string)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + string + "\" not found on class: " + this.type.getName());
    }

    protected String getCachedFieldName(CachedField cachedField) {
        return this.config.getCachedFieldNameStrategy().getName(cachedField);
    }

    public void removeField(String string) {
        CachedField cachedField;
        int n2;
        for (n2 = 0; n2 < this.fields.length; ++n2) {
            cachedField = this.fields[n2];
            if (!this.getCachedFieldName(cachedField).equals(string)) continue;
            CachedField[] cachedFieldArray = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, cachedFieldArray, 0, n2);
            System.arraycopy(this.fields, n2 + 1, cachedFieldArray, n2, cachedFieldArray.length - n2);
            this.fields = cachedFieldArray;
            this.removedFields.add(cachedField);
            return;
        }
        for (n2 = 0; n2 < this.transientFields.length; ++n2) {
            cachedField = this.transientFields[n2];
            if (!this.getCachedFieldName(cachedField).equals(string)) continue;
            CachedField[] cachedFieldArray = new CachedField[this.transientFields.length - 1];
            System.arraycopy(this.transientFields, 0, cachedFieldArray, 0, n2);
            System.arraycopy(this.transientFields, n2 + 1, cachedFieldArray, n2, cachedFieldArray.length - n2);
            this.transientFields = cachedFieldArray;
            this.removedFields.add(cachedField);
            return;
        }
        throw new IllegalArgumentException("Field \"" + string + "\" not found on class: " + this.type.getName());
    }

    public void removeField(CachedField cachedField) {
        CachedField cachedField2;
        int n2;
        for (n2 = 0; n2 < this.fields.length; ++n2) {
            cachedField2 = this.fields[n2];
            if (cachedField2 != cachedField) continue;
            CachedField[] cachedFieldArray = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, cachedFieldArray, 0, n2);
            System.arraycopy(this.fields, n2 + 1, cachedFieldArray, n2, cachedFieldArray.length - n2);
            this.fields = cachedFieldArray;
            this.removedFields.add(cachedField2);
            return;
        }
        for (n2 = 0; n2 < this.transientFields.length; ++n2) {
            cachedField2 = this.transientFields[n2];
            if (cachedField2 != cachedField) continue;
            CachedField[] cachedFieldArray = new CachedField[this.transientFields.length - 1];
            System.arraycopy(this.transientFields, 0, cachedFieldArray, 0, n2);
            System.arraycopy(this.transientFields, n2 + 1, cachedFieldArray, n2, cachedFieldArray.length - n2);
            this.transientFields = cachedFieldArray;
            this.removedFields.add(cachedField2);
            return;
        }
        throw new IllegalArgumentException("Field \"" + cachedField + "\" not found on class: " + this.type.getName());
    }

    public CachedField[] getFields() {
        return this.fields;
    }

    public CachedField[] getTransientFields() {
        return this.transientFields;
    }

    public Class getType() {
        return this.type;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public boolean getUseAsmEnabled() {
        return this.config.isUseAsm();
    }

    public boolean getUseMemRegions() {
        return this.useMemRegions;
    }

    public boolean getCopyTransient() {
        return this.config.isCopyTransient();
    }

    public boolean getSerializeTransient() {
        return this.config.isSerializeTransient();
    }

    protected T createCopy(Kryo kryo, T t2) {
        return (T)kryo.newInstance(t2.getClass());
    }

    @Override
    public T copy(Kryo kryo, T t2) {
        int n2;
        int n3;
        T t3 = this.createCopy(kryo, t2);
        kryo.reference(t3);
        if (this.config.isCopyTransient()) {
            n3 = this.transientFields.length;
            for (n2 = 0; n2 < n3; ++n2) {
                this.transientFields[n2].copy(t2, t3);
            }
        }
        n3 = this.fields.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.fields[n2].copy(t2, t3);
        }
        return t3;
    }

    final Generics getGenericsScope() {
        return this.genericsScope;
    }

    static {
        block3: {
            try {
                unsafeUtilClass = FieldSerializer.class.getClassLoader().loadClass("com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.UnsafeUtil");
                Method method = unsafeUtilClass.getMethod("unsafe", new Class[0]);
                sortFieldsByOffsetMethod = unsafeUtilClass.getMethod("sortFieldsByOffset", List.class);
                Object object = method.invoke(null, new Object[0]);
                if (object != null) {
                    unsafeAvailable = true;
                }
            }
            catch (Throwable throwable) {
                if (!Log.TRACE) break block3;
                Log.trace("kryo", "sun.misc.Unsafe is unavailable.");
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Bind {
        public Class<? extends Serializer> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    public static interface CachedFieldNameStrategy {
        public static final CachedFieldNameStrategy DEFAULT = new CachedFieldNameStrategy(){

            @Override
            public String getName(CachedField cachedField) {
                return cachedField.field.getName();
            }
        };
        public static final CachedFieldNameStrategy EXTENDED = new CachedFieldNameStrategy(){

            @Override
            public String getName(CachedField cachedField) {
                return cachedField.field.getDeclaringClass().getSimpleName() + "." + cachedField.field.getName();
            }
        };

        public String getName(CachedField var1);
    }

    public static interface CachedFieldFactory {
        public CachedField createCachedField(Class var1, Field var2, FieldSerializer var3);
    }

    public static abstract class CachedField<X> {
        Field field;
        FieldAccess access;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;
        long offset = -1L;
        boolean varIntsEnabled = true;

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

