/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateDeserializer
extends JSR310DateTimeDeserializerBase<LocalDate> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final LocalDateDeserializer INSTANCE = new LocalDateDeserializer();

    protected LocalDateDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalDate.class, dateTimeFormatter);
    }

    public LocalDateDeserializer(LocalDateDeserializer localDateDeserializer, DateTimeFormatter dateTimeFormatter) {
        super(localDateDeserializer, dateTimeFormatter);
    }

    protected LocalDateDeserializer(LocalDateDeserializer localDateDeserializer, Boolean bl2) {
        super(localDateDeserializer, bl2);
    }

    protected LocalDateDeserializer(LocalDateDeserializer localDateDeserializer, JsonFormat.Shape shape) {
        super(localDateDeserializer, shape);
    }

    protected LocalDateDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new LocalDateDeserializer(this, dateTimeFormatter);
    }

    protected LocalDateDeserializer withLeniency(Boolean bl2) {
        return new LocalDateDeserializer(this, bl2);
    }

    protected LocalDateDeserializer withShape(JsonFormat.Shape shape) {
        return new LocalDateDeserializer(this, shape);
    }

    @Override
    public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS) && (jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT)) {
                LocalDate localDate = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return localDate;
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                int n2 = jsonParser.getIntValue();
                int n3 = jsonParser.nextIntValue(-1);
                int n4 = jsonParser.nextIntValue(-1);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                }
                return LocalDate.of(n2, n3, n4);
            }
            deserializationContext.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{jsonToken});
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDate)jsonParser.getEmbeddedObject();
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT || this.isLenient()) {
                return LocalDate.ofEpochDay(jsonParser.getLongValue());
            }
            return (LocalDate)this._failForNotLenient(jsonParser, deserializationContext, JsonToken.VALUE_STRING);
        }
        return (LocalDate)this._handleUnexpectedToken(deserializationContext, jsonParser, "Expected array or string.", new Object[0]);
    }

    protected LocalDate _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (LocalDate)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        try {
            DateTimeFormatter dateTimeFormatter = this._formatter;
            if (dateTimeFormatter == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T') {
                if (this.isLenient()) {
                    if (string2.endsWith("Z")) {
                        return LocalDate.parse(string2.substring(0, string2.length() - 1), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                    }
                    return LocalDate.parse(string2, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                }
                JavaType javaType = this.getValueType(deserializationContext);
                return (LocalDate)deserializationContext.handleWeirdStringValue(javaType.getRawClass(), string2, "Should not contain time component when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDate.parse(string2, dateTimeFormatter);
        }
        catch (DateTimeException dateTimeException) {
            return (LocalDate)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

