/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class LocalDateTimeSerializer
extends JSR310FormattedSerializerBase<LocalDateTime> {
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    protected LocalDateTimeSerializer() {
        this((DateTimeFormatter)null);
    }

    public LocalDateTimeSerializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalDateTime.class, dateTimeFormatter);
    }

    private LocalDateTimeSerializer(LocalDateTimeSerializer localDateTimeSerializer, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter) {
        super(localDateTimeSerializer, bl2, bl3, dateTimeFormatter, null);
    }

    @Override
    protected JSR310FormattedSerializerBase<LocalDateTime> withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new LocalDateTimeSerializer(this, bl2, this._useNanoseconds, dateTimeFormatter);
    }

    protected DateTimeFormatter _defaultFormatter() {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    }

    @Override
    public void serialize(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            jsonGenerator.writeStartArray();
            this._serializeAsArrayContents(localDateTime, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        } else {
            DateTimeFormatter dateTimeFormatter = this._formatter;
            if (dateTimeFormatter == null) {
                dateTimeFormatter = this._defaultFormatter();
            }
            jsonGenerator.writeString(localDateTime.format(dateTimeFormatter));
        }
    }

    @Override
    public void serializeWithType(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(localDateTime, this.serializationShape(serializerProvider)));
        if (writableTypeId.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(localDateTime, jsonGenerator, serializerProvider);
        } else {
            DateTimeFormatter dateTimeFormatter = this._formatter;
            if (dateTimeFormatter == null) {
                dateTimeFormatter = this._defaultFormatter();
            }
            jsonGenerator.writeString(localDateTime.format(dateTimeFormatter));
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    private final void _serializeAsArrayContents(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(localDateTime.getYear());
        jsonGenerator.writeNumber(localDateTime.getMonthValue());
        jsonGenerator.writeNumber(localDateTime.getDayOfMonth());
        jsonGenerator.writeNumber(localDateTime.getHour());
        jsonGenerator.writeNumber(localDateTime.getMinute());
        int n2 = localDateTime.getSecond();
        int n3 = localDateTime.getNano();
        if (n2 > 0 || n3 > 0) {
            jsonGenerator.writeNumber(n2);
            if (n3 > 0) {
                if (this.useNanoseconds(serializerProvider)) {
                    jsonGenerator.writeNumber(n3);
                } else {
                    jsonGenerator.writeNumber(localDateTime.get(ChronoField.MILLI_OF_SECOND));
                }
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        return this.useTimestamp(serializerProvider) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean bl2, Boolean bl3) {
        return new LocalDateTimeSerializer(this, this._useTimestamp, bl3, this._formatter);
    }
}

