/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.List;

final class ExplicitOrdering<T>
extends Ordering<T>
implements Serializable {
    final ImmutableMap<T, Integer> rankMap;

    ExplicitOrdering(List<T> list) {
        this(Maps.indexMap(list));
    }

    ExplicitOrdering(ImmutableMap<T, Integer> immutableMap) {
        this.rankMap = immutableMap;
    }

    @Override
    public int compare(T t2, T t3) {
        return this.rank(t2) - this.rank(t3);
    }

    private int rank(T t2) {
        Integer n2 = this.rankMap.get(t2);
        if (n2 == null) {
            throw new Ordering.IncomparableValueException(t2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ExplicitOrdering) {
            ExplicitOrdering explicitOrdering = (ExplicitOrdering)object;
            return this.rankMap.equals(explicitOrdering.rankMap);
        }
        return false;
    }

    public int hashCode() {
        return this.rankMap.hashCode();
    }

    public String toString() {
        String string = String.valueOf(this.rankMap.keySet());
        return new StringBuilder(19 + String.valueOf(string).length()).append("Ordering.explicit(").append(string).append(")").toString();
    }
}

