/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.math.IntMath;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;

public final class ByteStreams {
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int n2) {
        }

        @Override
        public void write(byte[] byArray) {
            Preconditions.checkNotNull(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            Preconditions.checkNotNull(byArray);
        }

        public String toString() {
            return "ByteStreams.nullOutputStream()";
        }
    };

    static byte[] createBuffer() {
        return new byte[8192];
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(outputStream);
        byte[] byArray = ByteStreams.createBuffer();
        long l2 = 0L;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    private static byte[] toByteArrayInternal(InputStream inputStream, Queue<byte[]> queue, int n2) throws IOException {
        int n3 = 8192;
        while (n2 < 0x7FFFFFF7) {
            byte[] byArray = new byte[Math.min(n3, 0x7FFFFFF7 - n2)];
            queue.add(byArray);
            int n4 = 0;
            while (n4 < byArray.length) {
                int n5 = inputStream.read(byArray, n4, byArray.length - n4);
                if (n5 == -1) {
                    return ByteStreams.combineBuffers(queue, n2);
                }
                n4 += n5;
                n2 += n5;
            }
            n3 = IntMath.saturatedMultiply(n3, 2);
        }
        if (inputStream.read() == -1) {
            return ByteStreams.combineBuffers(queue, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    private static byte[] combineBuffers(Queue<byte[]> queue, int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        for (int i2 = n2; i2 > 0; i2 -= n3) {
            byte[] byArray2 = queue.remove();
            n3 = Math.min(i2, byArray2.length);
            int n4 = n2 - i2;
            System.arraycopy(byArray2, 0, byArray, n4, n3);
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(inputStream);
        return ByteStreams.toByteArrayInternal(inputStream, new ArrayDeque<byte[]>(20), 0);
    }

    static byte[] toByteArray(InputStream inputStream, long l2) throws IOException {
        int n2;
        int n3;
        Preconditions.checkArgument(l2 >= 0L, "expectedSize (%s) must be non-negative", l2);
        if (l2 > 0x7FFFFFF7L) {
            throw new OutOfMemoryError(new StringBuilder(62).append(l2).append(" bytes is too large to fit in a byte array").toString());
        }
        byte[] byArray = new byte[(int)l2];
        for (int i2 = (int)l2; i2 > 0; i2 -= n3) {
            n2 = (int)l2 - i2;
            n3 = inputStream.read(byArray, n2, i2);
            if (n3 != -1) continue;
            return Arrays.copyOf(byArray, n2);
        }
        n2 = inputStream.read();
        if (n2 == -1) {
            return byArray;
        }
        ArrayDeque<byte[]> arrayDeque = new ArrayDeque<byte[]>(22);
        arrayDeque.add(byArray);
        arrayDeque.add(new byte[]{(byte)n2});
        return ByteStreams.toByteArrayInternal(inputStream, arrayDeque, byArray.length + 1);
    }

    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        ByteStreams.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = ByteStreams.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException(new StringBuilder(81).append("reached end of stream after reading ").append(n4).append(" bytes; ").append(n3).append(" bytes expected").toString());
        }
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(byArray);
        if (n3 < 0) {
            throw new IndexOutOfBoundsException(String.format("len (%s) cannot be negative", n3));
        }
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        for (n4 = 0; n4 < n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) != -1; n4 += n5) {
        }
        return n4;
    }
}

