/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.SourceLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModule;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SourceFolderLibrary
extends SourceLibrary {
    private List<File> sourceFolders = new LinkedList<File>();

    public SourceFolderLibrary(AbstractClassLibrary abstractClassLibrary) {
        super(abstractClassLibrary);
    }

    public JavaModule addSourceFolder(File file) {
        this.sourceFolders.add(file);
        return this.resolveJavaModule(file);
    }

    private JavaModule resolveJavaModule(File file) {
        JavaModule javaModule = null;
        File file2 = new File(file, "module-info.java");
        if (file2.isFile()) {
            try {
                javaModule = this.parse(new FileReader(file2), file2.toURI().toURL()).getModuleInfo();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return javaModule;
    }

    @Override
    protected JavaClass resolveJavaClass(String string) {
        JavaClass javaClass = super.resolveJavaClass(string);
        for (File file : this.sourceFolders) {
            String string2;
            File file2 = new File(file, (string2 = string.split("\\$")[0]).replace('.', File.separatorChar) + ".java");
            if (!file2.isFile()) continue;
            try {
                JavaSource javaSource = this.parse(new FileReader(file2), file2.toURI().toURL()).getSource();
                javaClass = javaSource.getClassByName(string);
                break;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return javaClass;
    }

    @Override
    protected boolean containsClassReference(String string) {
        boolean bl2 = super.containsClassReference(string);
        Iterator<File> iterator = this.sourceFolders.iterator();
        while (!bl2 && iterator.hasNext()) {
            String string2;
            File file = iterator.next();
            File file2 = new File(file, (string2 = string.split("\\$")[0]).replace('.', File.separatorChar) + ".java");
            bl2 = file2.exists() && file2.isFile();
        }
        return bl2;
    }
}

