/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ArrayUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.CharSequenceUtils;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    private static String appendIfMissing(String string, CharSequence charSequence, boolean bl2, CharSequence ... charSequenceArray) {
        if (string == null || StringUtils.isEmpty(charSequence) || StringUtils.endsWith(string, charSequence, bl2)) {
            return string;
        }
        if (ArrayUtils.isNotEmpty(charSequenceArray)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (!StringUtils.endsWith(string, charSequence2, bl2)) continue;
                return string;
            }
        }
        return string + charSequence.toString();
    }

    public static String appendIfMissing(String string, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.appendIfMissing(string, charSequence, false, charSequenceArray);
    }

    public static String capitalize(String string) {
        int n2;
        int n3;
        int n4 = StringUtils.length(string);
        if (n4 == 0) {
            return string;
        }
        int n5 = string.codePointAt(0);
        if (n5 == (n3 = Character.toTitleCase(n5))) {
            return string;
        }
        int[] nArray = new int[n4];
        int n6 = 0;
        nArray[n6++] = n3;
        for (int i2 = Character.charCount(n5); i2 < n4; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            nArray[n6++] = n2;
        }
        return new String(nArray, 0, n6);
    }

    public static String defaultString(String string) {
        return StringUtils.defaultString(string, "");
    }

    public static String defaultString(String string, String string2) {
        return string == null ? string2 : string;
    }

    private static boolean endsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        int n2 = charSequence.length() - charSequence2.length();
        return CharSequenceUtils.regionMatches(charSequence, bl2, n2, charSequence2, 0, charSequence2.length());
    }

    public static boolean isBlank(CharSequence charSequence) {
        int n2 = StringUtils.length(charSequence);
        if (n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return !StringUtils.isBlank(charSequence);
    }

    public static int length(CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static String[] split(String string, char c2) {
        return StringUtils.splitWorker(string, c2, false);
    }

    public static String[] split(String string, String string2) {
        return StringUtils.splitWorker(string, string2, -1, false);
    }

    public static String[] split(String string, String string2, int n2) {
        return StringUtils.splitWorker(string, string2, n2, false);
    }

    private static String[] splitWorker(String string, char c2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (n3 < n2) {
            if (string.charAt(n3) == c2) {
                if (bl3 || bl2) {
                    arrayList.add(string.substring(n4, n3));
                    bl3 = false;
                    bl4 = true;
                }
                n4 = ++n3;
                continue;
            }
            bl4 = false;
            bl3 = true;
            ++n3;
        }
        if (bl3 || bl2 && bl4) {
            arrayList.add(string.substring(n4, n3));
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private static String[] splitWorker(String string, String string2, int n2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string2 == null) {
            while (n5 < n3) {
                if (Character.isWhitespace(string.charAt(n5))) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        } else if (string2.length() == 1) {
            char c2 = string2.charAt(0);
            while (n5 < n3) {
                if (string.charAt(n5) == c2) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        } else {
            while (n5 < n3) {
                if (string2.indexOf(string.charAt(n5)) >= 0) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        }
        if (bl3 || bl2 && bl4) {
            arrayList.add(string.substring(n6, n5));
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String stripStart(String string, String string2) {
        int n2;
        int n3 = StringUtils.length(string);
        if (n3 == 0) {
            return string;
        }
        if (string2 == null) {
            for (n2 = 0; n2 != n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
        } else {
            if (string2.isEmpty()) {
                return string;
            }
            while (n2 != n3 && string2.indexOf(string.charAt(n2)) != -1) {
                ++n2;
            }
        }
        return string.substring(n2);
    }

    public static String substringBefore(String string, String string2) {
        if (StringUtils.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string2.isEmpty()) {
            return "";
        }
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }
}

