/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpReceiver;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpSender;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.CyclicTimeouts;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;

public abstract class HttpChannel
implements CyclicTimeouts.Expirable {
    protected static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final HttpDestination _destination;
    private HttpExchange _exchange;

    protected HttpChannel(HttpDestination httpDestination) {
        this._destination = httpDestination;
    }

    public void destroy() {
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean associate(HttpExchange httpExchange) {
        boolean bl2 = false;
        boolean bl3 = true;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            if (this._exchange == null) {
                bl3 = false;
                bl2 = httpExchange.associate(this);
                if (bl2) {
                    this._exchange = httpExchange;
                }
            }
        }
        if (bl3) {
            httpExchange.getRequest().abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("{} associated {} to {}", httpExchange, bl2, this);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disassociate(HttpExchange httpExchange) {
        boolean bl2 = false;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            HttpExchange httpExchange2 = this._exchange;
            this._exchange = null;
            if (httpExchange2 == httpExchange) {
                httpExchange2.disassociate(this);
                bl2 = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} disassociated {} from {}", httpExchange, bl2, this);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpExchange getHttpExchange() {
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            return this._exchange;
        }
    }

    @Override
    public long getExpireNanoTime() {
        HttpExchange httpExchange = this.getHttpExchange();
        return httpExchange != null ? httpExchange.getExpireNanoTime() : Long.MAX_VALUE;
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    public void send() {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange != null) {
            this.send(httpExchange);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    public void proceed(HttpExchange httpExchange, Throwable throwable) {
        this.getHttpSender().proceed(httpExchange, throwable);
    }

    public boolean abort(HttpExchange httpExchange, Throwable throwable, Throwable throwable2) {
        boolean bl2 = false;
        if (throwable != null) {
            bl2 = this.getHttpSender().abort(httpExchange, throwable);
        }
        boolean bl3 = false;
        if (throwable2 != null) {
            bl3 = this.abortResponse(httpExchange, throwable2);
        }
        return bl2 || bl3;
    }

    public boolean abortResponse(HttpExchange httpExchange, Throwable throwable) {
        return this.getHttpReceiver().abort(httpExchange, throwable);
    }

    public Result exchangeTerminating(HttpExchange httpExchange, Result result) {
        return result;
    }

    public void exchangeTerminated(HttpExchange httpExchange, Result result) {
        this.disassociate(httpExchange);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange());
    }
}

