/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.DateCache;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.AbstractLogger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;

public class StdErrLog
extends AbstractLogger {
    private static final String EOL;
    private static final Object[] EMPTY_ARGS;
    private static int __tagpad;
    private static DateCache _dateCache;
    private static final boolean __source;
    private static final boolean __long;
    private static final boolean __escape;
    private int _level;
    private int _configuredLevel;
    private PrintStream _altStream;
    private boolean _source;
    private boolean _printLongNames = __long;
    private final String _name;
    protected final String _abbrevname;
    private boolean _hideStacks = false;

    public static int getLoggingLevel(Properties properties, String string) {
        int n2 = StdErrLog.lookupLoggingLevel(properties, string);
        if (n2 == -1 && (n2 = StdErrLog.lookupLoggingLevel(properties, "log")) == -1) {
            n2 = 2;
        }
        return n2;
    }

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String string) {
        this(string, null);
    }

    public StdErrLog(String string, Properties properties) {
        String string2;
        boolean bl2;
        boolean bl3 = bl2 = properties != Log.__props;
        if (properties != null && bl2) {
            Log.__props.putAll((Map<?, ?>)properties);
        }
        this._name = string == null ? "" : string;
        this._abbrevname = StdErrLog.condensePackageString(this._name);
        this._configuredLevel = this._level = StdErrLog.getLoggingLevel(Log.__props, this._name);
        try {
            string2 = StdErrLog.getLoggingProperty(Log.__props, this._name, "SOURCE");
            this._source = string2 == null ? __source : Boolean.parseBoolean(string2);
        }
        catch (AccessControlException accessControlException) {
            this._source = __source;
        }
        try {
            string2 = StdErrLog.getLoggingProperty(Log.__props, this._name, "STACKS");
            this._hideStacks = string2 != null && !Boolean.parseBoolean(string2);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setPrintLongNames(boolean bl2) {
        this._printLongNames = bl2;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        if (this._level <= 3) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":WARN:", string, objectArray);
            this.println(stringBuilder);
        }
    }

    @Override
    public void warn(Throwable throwable) {
        this.warn("", throwable);
    }

    @Override
    public void warn(String string, Throwable throwable) {
        if (this._level <= 3) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":WARN:", string, throwable);
            this.println(stringBuilder);
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this._level <= 2) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":INFO:", string, objectArray);
            this.println(stringBuilder);
        }
    }

    @Override
    public void info(String string, Throwable throwable) {
        if (this._level <= 2) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":INFO:", string, throwable);
            this.println(stringBuilder);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._level <= 1;
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":DBUG:", string, objectArray);
            this.println(stringBuilder);
        }
    }

    @Override
    public void debug(String string, long l2) {
        if (this.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":DBUG:", string, l2);
            this.println(stringBuilder);
        }
    }

    @Override
    public void debug(Throwable throwable) {
        this.debug("", throwable);
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":DBUG:", string, throwable);
            this.println(stringBuilder);
        }
    }

    private void println(StringBuilder stringBuilder) {
        if (this._altStream != null) {
            this._altStream.println(stringBuilder);
        } else {
            System.err.println(stringBuilder);
        }
    }

    private void format(StringBuilder stringBuilder, String string, String string2, Object ... objectArray) {
        long l2 = System.currentTimeMillis();
        int n2 = (int)(l2 % 1000L);
        String string3 = _dateCache.formatNow(l2);
        this.tag(stringBuilder, string3, n2, string);
        Object[] objectArray2 = EMPTY_ARGS;
        int n3 = 0;
        Throwable throwable = null;
        if (objectArray != null) {
            objectArray2 = objectArray;
            n3 = objectArray.length;
            if (n3 > 0 && objectArray[n3 - 1] instanceof Throwable) {
                throwable = (Throwable)objectArray[n3 - 1];
                --n3;
            }
        }
        if (string2 == null) {
            string2 = "";
            for (int i2 = 0; i2 < n3; ++i2) {
                string2 = string2 + "{} ";
            }
        }
        String string4 = "{}";
        int n4 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            Object object = objectArray2[i3];
            int n5 = string2.indexOf(string4, n4);
            if (n5 < 0) {
                this.escape(stringBuilder, string2.substring(n4));
                stringBuilder.append(" ");
                if (object != null) {
                    stringBuilder.append(object);
                }
                n4 = string2.length();
                continue;
            }
            this.escape(stringBuilder, string2.substring(n4, n5));
            if (object != null) {
                stringBuilder.append(object);
            }
            n4 = n5 + string4.length();
        }
        this.escape(stringBuilder, string2.substring(n4));
        if (throwable != null) {
            if (this.isHideStacks()) {
                stringBuilder.append(": ").append(throwable);
            } else {
                this.formatCause(stringBuilder, throwable, "");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void formatCause(StringBuilder stringBuilder, Throwable throwable, String string) {
        void object;
        stringBuilder.append(EOL).append(string);
        this.escape(stringBuilder, throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        boolean i2 = false;
        while (stackTraceElementArray != null && object < stackTraceElementArray.length) {
            stringBuilder.append(EOL).append(string).append("\tat ");
            this.escape(stringBuilder, stackTraceElementArray[object].toString());
            ++object;
        }
        for (Throwable throwable2 : throwable.getSuppressed()) {
            stringBuilder.append(EOL).append(string).append("Suppressed: ");
            this.formatCause(stringBuilder, throwable2, "\t|" + string);
        }
        Throwable throwable3 = throwable.getCause();
        if (throwable3 != null && throwable3 != throwable) {
            stringBuilder.append(EOL).append(string).append("Caused by: ");
            this.formatCause(stringBuilder, throwable3, string);
        }
    }

    private void escape(StringBuilder stringBuilder, String string) {
        if (__escape) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (Character.isISOControl(c2)) {
                    if (c2 == '\n') {
                        stringBuilder.append('|');
                        continue;
                    }
                    if (c2 == '\r') {
                        stringBuilder.append('<');
                        continue;
                    }
                    stringBuilder.append('?');
                    continue;
                }
                stringBuilder.append(c2);
            }
        } else {
            stringBuilder.append(string);
        }
    }

    private void tag(StringBuilder stringBuilder, String string, int n2, String string2) {
        int n3;
        stringBuilder.setLength(0);
        stringBuilder.append(string);
        if (n2 > 99) {
            stringBuilder.append('.');
        } else if (n2 > 9) {
            stringBuilder.append(".0");
        } else {
            stringBuilder.append(".00");
        }
        stringBuilder.append(n2).append(string2);
        String string3 = this._printLongNames ? this._name : this._abbrevname;
        String string4 = Thread.currentThread().getName();
        int n4 = n3 = __tagpad > 0 ? string3.length() + string4.length() - __tagpad : 0;
        if (n3 < 0) {
            stringBuilder.append(string3).append(':').append("                                                  ", 0, -n3).append(string4);
        } else if (n3 == 0) {
            stringBuilder.append(string3).append(':').append(string4);
        }
        stringBuilder.append(':');
        if (this._source) {
            StackTraceElement[] stackTraceElementArray;
            Throwable throwable = new Throwable();
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                String string5 = stackTraceElement.getClassName();
                if (string5.equals(StdErrLog.class.getName()) || string5.equals(Log.class.getName())) continue;
                if (!this._printLongNames && string5.startsWith("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.")) {
                    stringBuilder.append(StdErrLog.condensePackageString(string5));
                } else {
                    stringBuilder.append(string5);
                }
                stringBuilder.append('#').append(stackTraceElement.getMethodName());
                if (stackTraceElement.getFileName() != null) {
                    stringBuilder.append('(').append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber()).append(')');
                }
                stringBuilder.append(':');
                break;
            }
        }
        stringBuilder.append(' ');
    }

    @Override
    protected Logger newLogger(String string) {
        StdErrLog stdErrLog = new StdErrLog(string);
        stdErrLog.setPrintLongNames(this._printLongNames);
        stdErrLog._altStream = this._altStream;
        if (this._level != this._configuredLevel) {
            stdErrLog._level = this._level;
        }
        return stdErrLog;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StdErrLog:");
        stringBuilder.append(this._name);
        stringBuilder.append(":LEVEL=");
        switch (this._level) {
            case 0: {
                stringBuilder.append("ALL");
                break;
            }
            case 1: {
                stringBuilder.append("DEBUG");
                break;
            }
            case 2: {
                stringBuilder.append("INFO");
                break;
            }
            case 3: {
                stringBuilder.append("WARN");
                break;
            }
            default: {
                stringBuilder.append("?");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void ignore(Throwable throwable) {
        if (this._level <= 0) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":IGNORED:", "", throwable);
            this.println(stringBuilder);
        }
    }

    static {
        String[] stringArray;
        EOL = System.lineSeparator();
        EMPTY_ARGS = new Object[0];
        __tagpad = Integer.parseInt(Log.__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.StdErrLog.TAG_PAD", "0"));
        __source = Boolean.parseBoolean(Log.__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.SOURCE", Log.__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.stderr.SOURCE", "false")));
        __long = Boolean.parseBoolean(Log.__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.stderr.LONG", "false"));
        __escape = Boolean.parseBoolean(Log.__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.stderr.ESCAPE", "true"));
        for (String string : stringArray = new String[]{"DEBUG", "com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.DEBUG", "com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.stderr.DEBUG"}) {
            if (System.getProperty(string) == null) continue;
            System.err.printf("System Property [%s] has been deprecated! (Use org.eclipse.jetty.LEVEL=DEBUG instead)%n", string);
        }
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

