/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.message;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ByteArrayOutputStream2;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriver;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.message.MessageAppender;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SimpleBinaryMessage
implements MessageAppender {
    private final EventDriver onEvent;
    protected ByteArrayOutputStream2 out;
    private int size;
    protected boolean finished;

    public SimpleBinaryMessage(EventDriver eventDriver) {
        this.onEvent = eventDriver;
        this.finished = false;
    }

    @Override
    public void appendFrame(ByteBuffer byteBuffer, boolean bl2) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (byteBuffer == null) {
            return;
        }
        this.onEvent.getPolicy().assertValidBinaryMessageSize(this.size + byteBuffer.remaining());
        this.size += byteBuffer.remaining();
        if (this.out == null) {
            this.out = bl2 ? new ByteArrayOutputStream2(this.size) : new ByteArrayOutputStream2(65535);
        }
        BufferUtil.writeTo(byteBuffer, this.out);
    }

    @Override
    public void messageComplete() {
        this.finished = true;
        byte[] byArray = this.out == null ? new byte[]{} : (this.out.getCount() == this.out.getBuf().length ? this.out.getBuf() : this.out.toByteArray());
        this.onEvent.onBinaryMessage(byArray);
    }
}

