/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ArrayNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ContainerNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.util.Arrays;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T> {
    protected final Boolean _supportsUpdates;

    public BaseNodeDeserializer(Class<T> clazz, Boolean bl2) {
        super(clazz);
        this._supportsUpdates = bl2;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._supportsUpdates;
    }

    protected void _handleDuplicateField(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, String string, ObjectNode objectNode, JsonNode jsonNode, JsonNode jsonNode2) throws IOException {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            deserializationContext.reportInputMismatch(JsonNode.class, "Duplicate field '%s' for `ObjectNode`: not allowed when `DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY` enabled", string);
        }
        if (deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES)) {
            if (jsonNode.isArray()) {
                ((ArrayNode)jsonNode).add(jsonNode2);
                objectNode.replace(string, jsonNode);
            } else {
                ArrayNode arrayNode = jsonNodeFactory.arrayNode();
                arrayNode.add(jsonNode);
                arrayNode.add(jsonNode2);
                objectNode.replace(string, arrayNode);
            }
        }
    }

    protected final ObjectNode _deserializeObjectAtName(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, ContainerStack containerStack) throws IOException {
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        String string = jsonParser.currentName();
        while (string != null) {
            ContainerNode<ContainerNode> containerNode;
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == null) {
                jsonToken = JsonToken.NOT_AVAILABLE;
            }
            switch (jsonToken.id()) {
                case 1: {
                    containerNode = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, jsonNodeFactory.objectNode());
                    break;
                }
                case 3: {
                    containerNode = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, jsonNodeFactory.arrayNode());
                    break;
                }
                default: {
                    containerNode = this._deserializeAnyScalar(jsonParser, deserializationContext);
                }
            }
            JsonNode jsonNode = objectNode.replace(string, containerNode);
            if (jsonNode != null) {
                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, string, objectNode, jsonNode, containerNode);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected final JsonNode updateObject(JsonParser var1_1, DeserializationContext var2_2, ObjectNode var3_3, ContainerStack var4_4) throws IOException {
        if (var1_1.isExpectedStartObjectToken()) {
            var5_5 = var1_1.nextFieldName();
        } else {
            if (!var1_1.hasToken(JsonToken.FIELD_NAME)) {
                return (JsonNode)this.deserialize(var1_1, var2_2);
            }
            var5_5 = var1_1.currentName();
        }
        var6_6 = var2_2.getNodeFactory();
        while (var5_5 != null) {
            block18: {
                block17: {
                    var7_7 = var1_1.nextToken();
                    var8_8 = var3_3.get(var5_5);
                    if (var8_8 == null) ** GOTO lbl-1000
                    if (!(var8_8 instanceof ObjectNode)) break block17;
                    if (var7_7 != JsonToken.START_OBJECT) ** GOTO lbl-1000
                    var9_9 /* !! */  = this.updateObject(var1_1, var2_2, (ObjectNode)var8_8, var4_4);
                    if (var9_9 /* !! */  != var8_8) {
                        var3_3.set(var5_5, var9_9 /* !! */ );
                    }
                    break block18;
                }
                if (var8_8 instanceof ArrayNode && var7_7 == JsonToken.START_ARRAY) {
                    this._deserializeContainerNoRecursion(var1_1, var2_2, var6_6, var4_4, (ArrayNode)var8_8);
                } else lbl-1000:
                // 3 sources

                {
                    if (var7_7 == null) {
                        var7_7 = JsonToken.NOT_AVAILABLE;
                    }
                    switch (var7_7.id()) {
                        case 1: {
                            var9_9 /* !! */  = this._deserializeContainerNoRecursion(var1_1, var2_2, var6_6, var4_4, var6_6.objectNode());
                            break;
                        }
                        case 3: {
                            var9_9 /* !! */  = this._deserializeContainerNoRecursion(var1_1, var2_2, var6_6, var4_4, var6_6.arrayNode());
                            break;
                        }
                        case 6: {
                            var9_9 /* !! */  = var6_6.textNode(var1_1.getText());
                            break;
                        }
                        case 7: {
                            var9_9 /* !! */  = this._fromInt(var1_1, var2_2, var6_6);
                            break;
                        }
                        case 9: {
                            var9_9 /* !! */  = var6_6.booleanNode(true);
                            break;
                        }
                        case 10: {
                            var9_9 /* !! */  = var6_6.booleanNode(false);
                            break;
                        }
                        case 11: {
                            var9_9 /* !! */  = var6_6.nullNode();
                            break;
                        }
                        default: {
                            var9_9 /* !! */  = this._deserializeRareScalar(var1_1, var2_2);
                        }
                    }
                    var3_3.set(var5_5, var9_9 /* !! */ );
                }
            }
            var5_5 = var1_1.nextFieldName();
        }
        return var3_3;
    }

    protected final ContainerNode<?> _deserializeContainerNoRecursion(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, ContainerStack containerStack, ContainerNode<?> containerNode) throws IOException {
        ContainerNode containerNode2 = containerNode;
        int n2 = deserializationContext.getDeserializationFeatures() & F_MASK_INT_COERCIONS;
        block21: do {
            block31: {
                Object object;
                ContainerNode containerNode3;
                block29: {
                    if (!(containerNode2 instanceof ObjectNode)) break block29;
                    containerNode3 = (ObjectNode)containerNode2;
                    object = jsonParser.nextFieldName();
                    while (object != null) {
                        block30: {
                            JsonNode jsonNode;
                            JsonNode jsonNode2;
                            JsonToken jsonToken = jsonParser.nextToken();
                            if (jsonToken == null) {
                                jsonToken = JsonToken.NOT_AVAILABLE;
                            }
                            switch (jsonToken.id()) {
                                case 1: {
                                    jsonNode2 = jsonNodeFactory.objectNode();
                                    JsonNode jsonNode3 = ((ObjectNode)containerNode3).replace((String)object, jsonNode2);
                                    if (jsonNode3 != null) {
                                        this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, jsonNode3, jsonNode2);
                                    }
                                    containerStack.push(containerNode2);
                                    containerNode2 = containerNode3 = jsonNode2;
                                    break block30;
                                }
                                case 3: {
                                    jsonNode2 = jsonNodeFactory.arrayNode();
                                    JsonNode jsonNode3 = ((ObjectNode)containerNode3).replace((String)object, jsonNode2);
                                    if (jsonNode3 != null) {
                                        this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, jsonNode3, jsonNode2);
                                    }
                                    containerStack.push(containerNode2);
                                    containerNode2 = jsonNode2;
                                    continue block21;
                                }
                                case 6: {
                                    jsonNode = jsonNodeFactory.textNode(jsonParser.getText());
                                    break;
                                }
                                case 7: {
                                    jsonNode = this._fromInt(jsonParser, n2, jsonNodeFactory);
                                    break;
                                }
                                case 8: {
                                    jsonNode = this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
                                    break;
                                }
                                case 9: {
                                    jsonNode = jsonNodeFactory.booleanNode(true);
                                    break;
                                }
                                case 10: {
                                    jsonNode = jsonNodeFactory.booleanNode(false);
                                    break;
                                }
                                case 11: {
                                    jsonNode = jsonNodeFactory.nullNode();
                                    break;
                                }
                                default: {
                                    jsonNode = this._deserializeRareScalar(jsonParser, deserializationContext);
                                }
                            }
                            jsonNode2 = ((ObjectNode)containerNode3).replace((String)object, jsonNode);
                            if (jsonNode2 != null) {
                                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, jsonNode2, jsonNode);
                            }
                        }
                        object = jsonParser.nextFieldName();
                    }
                    break block31;
                }
                containerNode3 = (ArrayNode)containerNode2;
                block23: while (true) {
                    if ((object = jsonParser.nextToken()) == null) {
                        object = JsonToken.NOT_AVAILABLE;
                    }
                    switch (((JsonToken)((Object)object)).id()) {
                        case 1: {
                            containerStack.push(containerNode2);
                            containerNode2 = jsonNodeFactory.objectNode();
                            ((ArrayNode)containerNode3).add(containerNode2);
                            continue block21;
                        }
                        case 3: {
                            containerStack.push(containerNode2);
                            containerNode2 = jsonNodeFactory.arrayNode();
                            ((ArrayNode)containerNode3).add(containerNode2);
                            continue block21;
                        }
                        case 4: {
                            break block23;
                        }
                        case 6: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.textNode(jsonParser.getText()));
                            continue block23;
                        }
                        case 7: {
                            ((ArrayNode)containerNode3).add(this._fromInt(jsonParser, n2, jsonNodeFactory));
                            continue block23;
                        }
                        case 8: {
                            ((ArrayNode)containerNode3).add(this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory));
                            continue block23;
                        }
                        case 9: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.booleanNode(true));
                            continue block23;
                        }
                        case 10: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.booleanNode(false));
                            continue block23;
                        }
                        case 11: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.nullNode());
                            continue block23;
                        }
                        default: {
                            ((ArrayNode)containerNode3).add(this._deserializeRareScalar(jsonParser, deserializationContext));
                            continue block23;
                        }
                    }
                    break;
                }
            }
            containerNode2 = containerStack.popOrNull();
        } while (containerNode2 != null);
        return containerNode;
    }

    protected final JsonNode _deserializeAnyScalar(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        switch (jsonParser.currentTokenId()) {
            case 2: {
                return jsonNodeFactory.objectNode();
            }
            case 6: {
                return jsonNodeFactory.textNode(jsonParser.getText());
            }
            case 7: {
                return this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 8: {
                return this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 9: {
                return jsonNodeFactory.booleanNode(true);
            }
            case 10: {
                return jsonNodeFactory.booleanNode(false);
            }
            case 11: {
                return jsonNodeFactory.nullNode();
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext);
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected final JsonNode _deserializeRareScalar(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 2: {
                return deserializationContext.getNodeFactory().objectNode();
            }
            case 8: {
                return this._fromFloat(jsonParser, deserializationContext, deserializationContext.getNodeFactory());
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext);
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, int n2, JsonNodeFactory jsonNodeFactory) throws IOException {
        if (n2 != 0) {
            if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2)) {
                return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
            }
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        JsonParser.NumberType numberType = jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        int n2 = deserializationContext.getDeserializationFeatures();
        JsonParser.NumberType numberType = (n2 & F_MASK_INT_COERCIONS) != 0 ? (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2) ? JsonParser.NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(n2) ? JsonParser.NumberType.LONG : jsonParser.getNumberType())) : jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromFloat(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        JsonParser.NumberType numberType = jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.BIG_DECIMAL) {
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            if (jsonParser.isNaN()) {
                return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
            }
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (numberType == JsonParser.NumberType.FLOAT) {
            return jsonNodeFactory.numberNode(jsonParser.getFloatValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
    }

    protected final JsonNode _fromEmbedded(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        Object object = jsonParser.getEmbeddedObject();
        if (object == null) {
            return jsonNodeFactory.nullNode();
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            return jsonNodeFactory.binaryNode((byte[])object);
        }
        if (object instanceof RawValue) {
            return jsonNodeFactory.rawValueNode((RawValue)object);
        }
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        return jsonNodeFactory.pojoNode(object);
    }

    static final class ContainerStack {
        private ContainerNode[] _stack;
        private int _top;
        private int _end;

        public void push(ContainerNode containerNode) {
            if (this._top < this._end) {
                this._stack[this._top++] = containerNode;
                return;
            }
            if (this._stack == null) {
                this._end = 10;
                this._stack = new ContainerNode[this._end];
            } else {
                this._end += Math.min(4000, Math.max(20, this._end >> 1));
                this._stack = Arrays.copyOf(this._stack, this._end);
            }
            this._stack[this._top++] = containerNode;
        }

        public ContainerNode popOrNull() {
            if (this._top == 0) {
                return null;
            }
            return this._stack[--this._top];
        }
    }
}

