/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.EnumValues;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public abstract class StdKeySerializers {
    protected static final JsonSerializer<Object> DEFAULT_KEY_SERIALIZER = new StdKeySerializer();
    protected static final JsonSerializer<Object> DEFAULT_STRING_SERIALIZER = new StringKeySerializer();

    public static JsonSerializer<Object> getStdKeySerializer(SerializationConfig serializationConfig, Class<?> clazz, boolean bl2) {
        if (clazz == null || clazz == Object.class) {
            return new Dynamic();
        }
        if (clazz == String.class) {
            return DEFAULT_STRING_SERIALIZER;
        }
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        if (clazz == Integer.class) {
            return new Default(5, clazz);
        }
        if (clazz == Long.class) {
            return new Default(6, clazz);
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz)) {
            return new Default(8, clazz);
        }
        if (clazz == Class.class) {
            return new Default(3, clazz);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new Default(1, clazz);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return new Default(2, clazz);
        }
        if (clazz == UUID.class) {
            return new Default(8, clazz);
        }
        if (clazz == byte[].class) {
            return new Default(7, clazz);
        }
        if (bl2) {
            return new Default(8, clazz);
        }
        return null;
    }

    public static JsonSerializer<Object> getFallbackKeySerializer(SerializationConfig serializationConfig, Class<?> clazz) {
        if (clazz != null) {
            if (clazz == Enum.class) {
                return new Dynamic();
            }
            if (ClassUtil.isEnumType(clazz)) {
                return EnumKeySerializer.construct(clazz, EnumValues.constructFromName(serializationConfig, clazz));
            }
        }
        return new Default(8, clazz);
    }

    public static class EnumKeySerializer
    extends StdSerializer<Object> {
        protected final EnumValues _values;

        protected EnumKeySerializer(Class<?> clazz, EnumValues enumValues) {
            super(clazz, false);
            this._values = enumValues;
        }

        public static EnumKeySerializer construct(Class<?> clazz, EnumValues enumValues) {
            return new EnumKeySerializer(clazz, enumValues);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                jsonGenerator.writeFieldName(object.toString());
                return;
            }
            Enum enum_ = (Enum)object;
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUM_KEYS_USING_INDEX)) {
                jsonGenerator.writeFieldName(String.valueOf(enum_.ordinal()));
                return;
            }
            jsonGenerator.writeFieldName(this._values.serializedValueFor(enum_));
        }
    }

    public static class StringKeySerializer
    extends StdSerializer<Object> {
        public StringKeySerializer() {
            super(String.class, false);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeFieldName((String)object);
        }
    }

    public static class Dynamic
    extends StdSerializer<Object> {
        protected transient PropertySerializerMap _dynamicSerializers = PropertySerializerMap.emptyForProperties();

        public Dynamic() {
            super(String.class, false);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            Class<?> clazz = object.getClass();
            JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer == null) {
                jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
            }
            jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitStringFormat(jsonFormatVisitorWrapper, javaType);
        }

        protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
            if (clazz == Object.class) {
                Default default_ = new Default(8, clazz);
                this._dynamicSerializers = propertySerializerMap.newWith(clazz, default_);
                return default_;
            }
            PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddKeySerializer(clazz, serializerProvider, null);
            if (propertySerializerMap != serializerAndMapResult.map) {
                this._dynamicSerializers = serializerAndMapResult.map;
            }
            return serializerAndMapResult.serializer;
        }
    }

    public static class Default
    extends StdSerializer<Object> {
        protected final int _typeId;

        public Default(int n2, Class<?> clazz) {
            super(clazz, false);
            this._typeId = n2;
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            switch (this._typeId) {
                case 1: {
                    serializerProvider.defaultSerializeDateKey((Date)object, jsonGenerator);
                    break;
                }
                case 2: {
                    serializerProvider.defaultSerializeDateKey(((Calendar)object).getTimeInMillis(), jsonGenerator);
                    break;
                }
                case 3: {
                    jsonGenerator.writeFieldName(((Class)object).getName());
                    break;
                }
                case 4: {
                    String string;
                    if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                        string = object.toString();
                    } else {
                        Enum enum_ = (Enum)object;
                        string = serializerProvider.isEnabled(SerializationFeature.WRITE_ENUM_KEYS_USING_INDEX) ? String.valueOf(enum_.ordinal()) : enum_.name();
                    }
                    jsonGenerator.writeFieldName(string);
                    break;
                }
                case 5: 
                case 6: {
                    jsonGenerator.writeFieldId(((Number)object).longValue());
                    break;
                }
                case 7: {
                    String string = serializerProvider.getConfig().getBase64Variant().encode((byte[])object);
                    jsonGenerator.writeFieldName(string);
                    break;
                }
                default: {
                    jsonGenerator.writeFieldName(object.toString());
                }
            }
        }
    }
}

