/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.file;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.Counters;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.CountingPathVisitor;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.DeleteOption;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.PathUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.StandardDeleteOption;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;

public class DeletingPathVisitor
extends CountingPathVisitor {
    private final String[] skip;
    private final boolean overrideReadOnly;
    private final LinkOption[] linkOptions;

    public DeletingPathVisitor(Counters.PathCounters pathCounters, LinkOption[] linkOptionArray, DeleteOption[] deleteOptionArray, String ... stringArray) {
        super(pathCounters);
        Object[] objectArray = stringArray != null ? (String[])stringArray.clone() : EMPTY_STRING_ARRAY;
        Arrays.sort(objectArray);
        this.skip = objectArray;
        this.overrideReadOnly = StandardDeleteOption.overrideReadOnly(deleteOptionArray);
        this.linkOptions = linkOptionArray == null ? PathUtils.NOFOLLOW_LINK_OPTION_ARRAY : (LinkOption[])linkOptionArray.clone();
    }

    private boolean accept(Path path) {
        return Arrays.binarySearch(this.skip, Objects.toString(path.getFileName(), null)) < 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DeletingPathVisitor deletingPathVisitor = (DeletingPathVisitor)object;
        return this.overrideReadOnly == deletingPathVisitor.overrideReadOnly && Arrays.equals(this.skip, deletingPathVisitor.skip);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Arrays.hashCode(this.skip);
        n3 = 31 * n3 + Objects.hash(this.overrideReadOnly);
        return n3;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        if (PathUtils.isEmptyDirectory(path)) {
            Files.deleteIfExists(path);
        }
        return super.postVisitDirectory(path, iOException);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        super.preVisitDirectory(path, basicFileAttributes);
        return this.accept(path) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (this.accept(path)) {
            if (Files.exists(path, this.linkOptions)) {
                if (this.overrideReadOnly) {
                    PathUtils.setReadOnly(path, false, this.linkOptions);
                }
                Files.deleteIfExists(path);
            }
            if (Files.isSymbolicLink(path)) {
                try {
                    Files.delete(path);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
        }
        this.updateFileCounters(path, basicFileAttributes);
        return FileVisitResult.CONTINUE;
    }
}

