/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn;

import com.gradle.maven.extension.internal.dep.org.apache.http.HttpClientConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpEntityEnclosingRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpException;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ManagedHttpClientConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.CPoolEntry;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.ConnectionShutdownException;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSession;

class CPoolProxy
implements ManagedHttpClientConnection,
HttpContext {
    private volatile CPoolEntry poolEntry;

    CPoolProxy(CPoolEntry cPoolEntry) {
        this.poolEntry = cPoolEntry;
    }

    CPoolEntry getPoolEntry() {
        return this.poolEntry;
    }

    CPoolEntry detach() {
        CPoolEntry cPoolEntry = this.poolEntry;
        this.poolEntry = null;
        return cPoolEntry;
    }

    ManagedHttpClientConnection getConnection() {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry == null) {
            return null;
        }
        return (ManagedHttpClientConnection)cPoolEntry.getConnection();
    }

    ManagedHttpClientConnection getValidConnection() {
        ManagedHttpClientConnection managedHttpClientConnection = this.getConnection();
        if (managedHttpClientConnection == null) {
            throw new ConnectionShutdownException();
        }
        return managedHttpClientConnection;
    }

    @Override
    public void close() throws IOException {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry != null) {
            cPoolEntry.closeConnection();
        }
    }

    @Override
    public void shutdown() throws IOException {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry != null) {
            cPoolEntry.shutdownConnection();
        }
    }

    @Override
    public boolean isOpen() {
        CPoolEntry cPoolEntry = this.poolEntry;
        return cPoolEntry != null ? !cPoolEntry.isClosed() : false;
    }

    @Override
    public boolean isStale() {
        ManagedHttpClientConnection managedHttpClientConnection = this.getConnection();
        return managedHttpClientConnection != null ? managedHttpClientConnection.isStale() : true;
    }

    @Override
    public void setSocketTimeout(int n2) {
        this.getValidConnection().setSocketTimeout(n2);
    }

    @Override
    public void bind(Socket socket) throws IOException {
        this.getValidConnection().bind(socket);
    }

    @Override
    public Socket getSocket() {
        return this.getValidConnection().getSocket();
    }

    @Override
    public SSLSession getSSLSession() {
        return this.getValidConnection().getSSLSession();
    }

    @Override
    public boolean isResponseAvailable(int n2) throws IOException {
        return this.getValidConnection().isResponseAvailable(n2);
    }

    @Override
    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        this.getValidConnection().sendRequestHeader(httpRequest);
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        this.getValidConnection().sendRequestEntity(httpEntityEnclosingRequest);
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        return this.getValidConnection().receiveResponseHeader();
    }

    @Override
    public void receiveResponseEntity(HttpResponse httpResponse) throws HttpException, IOException {
        this.getValidConnection().receiveResponseEntity(httpResponse);
    }

    @Override
    public void flush() throws IOException {
        this.getValidConnection().flush();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getValidConnection().getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.getValidConnection().getRemotePort();
    }

    @Override
    public Object getAttribute(String string) {
        ManagedHttpClientConnection managedHttpClientConnection = this.getValidConnection();
        return managedHttpClientConnection instanceof HttpContext ? ((HttpContext)((Object)managedHttpClientConnection)).getAttribute(string) : null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        ManagedHttpClientConnection managedHttpClientConnection = this.getValidConnection();
        if (managedHttpClientConnection instanceof HttpContext) {
            ((HttpContext)((Object)managedHttpClientConnection)).setAttribute(string, object);
        }
    }

    @Override
    public Object removeAttribute(String string) {
        ManagedHttpClientConnection managedHttpClientConnection = this.getValidConnection();
        return managedHttpClientConnection instanceof HttpContext ? ((HttpContext)((Object)managedHttpClientConnection)).removeAttribute(string) : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CPoolProxy{");
        ManagedHttpClientConnection managedHttpClientConnection = this.getConnection();
        if (managedHttpClientConnection != null) {
            stringBuilder.append(managedHttpClientConnection);
        } else {
            stringBuilder.append("detached");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static HttpClientConnection newProxy(CPoolEntry cPoolEntry) {
        return new CPoolProxy(cPoolEntry);
    }

    private static CPoolProxy getProxy(HttpClientConnection httpClientConnection) {
        if (!CPoolProxy.class.isInstance(httpClientConnection)) {
            throw new IllegalStateException("Unexpected connection proxy class: " + httpClientConnection.getClass());
        }
        return (CPoolProxy)CPoolProxy.class.cast(httpClientConnection);
    }

    public static CPoolEntry getPoolEntry(HttpClientConnection httpClientConnection) {
        CPoolEntry cPoolEntry = CPoolProxy.getProxy(httpClientConnection).getPoolEntry();
        if (cPoolEntry == null) {
            throw new ConnectionShutdownException();
        }
        return cPoolEntry;
    }

    public static CPoolEntry detach(HttpClientConnection httpClientConnection) {
        return CPoolProxy.getProxy(httpClientConnection).detach();
    }
}

