/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;

public class DateCache {
    private final String _formatString;
    private final String _tzFormatString;
    private final DateTimeFormatter _tzFormat;
    private final Locale _locale;
    private final ZoneId _zoneId;
    private volatile Tick _tick;

    public DateCache() {
        this("EEE MMM dd HH:mm:ss zzz yyyy");
    }

    public DateCache(String string) {
        this(string, null, TimeZone.getDefault());
    }

    public DateCache(String string, Locale locale, TimeZone timeZone) {
        this._formatString = string;
        this._locale = locale;
        int n2 = this._formatString.indexOf("ZZZ");
        if (n2 >= 0) {
            String string2 = this._formatString.substring(0, n2);
            String string3 = this._formatString.substring(n2 + 3);
            int n3 = timeZone.getRawOffset();
            StringBuilder stringBuilder = new StringBuilder(this._formatString.length() + 10);
            stringBuilder.append(string2);
            stringBuilder.append("'");
            if (n3 >= 0) {
                stringBuilder.append('+');
            } else {
                n3 = -n3;
                stringBuilder.append('-');
            }
            int n4 = n3 / 60000;
            int n5 = n4 / 60;
            int n6 = n4 % 60;
            if (n5 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n5);
            if (n6 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n6);
            stringBuilder.append('\'');
            stringBuilder.append(string3);
            this._tzFormatString = stringBuilder.toString();
        } else {
            this._tzFormatString = this._formatString;
        }
        this._tzFormat = this._locale != null ? DateTimeFormatter.ofPattern(this._tzFormatString, this._locale) : DateTimeFormatter.ofPattern(this._tzFormatString);
        this._zoneId = timeZone.toZoneId();
        this._tzFormat.withZone(this._zoneId);
        this._tick = null;
    }

    public String formatNow(long l2) {
        long l3 = l2 / 1000L;
        Tick tick = this._tick;
        if (tick != null && tick._seconds == l3) {
            return tick._string;
        }
        return this.formatTick((long)l2)._string;
    }

    protected Tick formatTick(long l2) {
        long l3 = l2 / 1000L;
        Tick tick = this._tick;
        if (tick == null || tick._seconds != l3) {
            String string = ZonedDateTime.ofInstant(Instant.ofEpochMilli(l2), this._zoneId).format(this._tzFormat);
            tick = this._tick = new Tick(l3, string);
        }
        return tick;
    }

    public static class Tick {
        final long _seconds;
        final String _string;

        public Tick(long l2, String string) {
            this._seconds = l2;
            this._string = string;
        }
    }
}

