/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Locker;

public abstract class IteratingCallback
implements Callback {
    private Locker _locker = new Locker();
    private State _state;
    private boolean _iterate;

    protected IteratingCallback() {
        this._state = State.IDLE;
    }

    protected IteratingCallback(boolean bl2) {
        this._state = bl2 ? State.SUCCEEDED : State.IDLE;
    }

    protected abstract Action process() throws Throwable;

    protected void onCompleteSuccess() {
    }

    protected void onCompleteFailure(Throwable throwable) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void iterate() {
        boolean bl2 = false;
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case PENDING: 
                case CALLED: {
                    break;
                }
                case IDLE: {
                    this._state = State.PROCESSING;
                    bl2 = true;
                    break;
                }
                case PROCESSING: {
                    this._iterate = true;
                    break;
                }
                case FAILED: 
                case SUCCEEDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        if (bl2) {
            this.processing();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processing() {
        boolean bl2 = false;
        block26: while (true) {
            Action action;
            try {
                action = this.process();
            }
            catch (Throwable throwable) {
                this.failed(throwable);
                break;
            }
            Locker.Lock lock = this._locker.lock();
            try {
                switch (this._state) {
                    case PROCESSING: {
                        switch (action) {
                            case IDLE: {
                                if (this._iterate) {
                                    this._iterate = false;
                                    this._state = State.PROCESSING;
                                    continue block26;
                                }
                                this._state = State.IDLE;
                                break block26;
                            }
                            case SCHEDULED: {
                                this._state = State.PENDING;
                                break block26;
                            }
                            case SUCCEEDED: {
                                this._iterate = false;
                                this._state = State.SUCCEEDED;
                                bl2 = true;
                                break block26;
                            }
                            default: {
                                throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                            }
                        }
                    }
                    case CALLED: {
                        switch (action) {
                            case SCHEDULED: {
                                this._state = State.PROCESSING;
                                continue block26;
                            }
                        }
                        throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                    }
                    case FAILED: 
                    case SUCCEEDED: 
                    case CLOSED: {
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                    }
                }
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            break;
        }
        if (bl2) {
            this.onCompleteSuccess();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void succeeded() {
        var1_1 = false;
        var2_2 = this._locker.lock();
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[this._state.ordinal()]) {
                case 4: {
                    this._state = State.CALLED;
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 1: {
                    this._state = State.PROCESSING;
                    var1_1 = true;
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 5: 
                case 7: {
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        finally {
            if (var2_2 != null) {
                var2_2.close();
            }
        }
        if (var1_1) {
            this.processing();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void failed(Throwable var1_1) {
        var2_2 = false;
        var3_3 = this._locker.lock();
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[this._state.ordinal()]) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 1: 
                case 4: {
                    this._state = State.FAILED;
                    var2_2 = true;
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        finally {
            if (var3_3 != null) {
                var3_3.close();
            }
        }
        if (var2_2) {
            this.onCompleteFailure(var1_1);
        }
    }

    public boolean isFailed() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl2 = this._state == State.FAILED;
            return bl2;
        }
    }

    public String toString() {
        return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    protected static enum Action {
        IDLE,
        SCHEDULED,
        SUCCEEDED;

    }

    private static enum State {
        IDLE,
        PROCESSING,
        PENDING,
        CALLED,
        SUCCEEDED,
        FAILED,
        CLOSED;

    }
}

