/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.Label;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.PropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CompilablePropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.FormatHelper;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Indexer;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyOrFieldReference
extends SpelNodeImpl {
    private final boolean nullSafe;
    private final String name;
    private String originalPrimitiveExitTypeDescriptor;
    private volatile PropertyAccessor cachedReadAccessor;
    private volatile PropertyAccessor cachedWriteAccessor;

    public PropertyOrFieldReference(boolean bl2, String string, int n2, int n3) {
        super(n2, n3, new SpelNodeImpl[0]);
        this.nullSafe = bl2;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ValueRef getValueRef(ExpressionState expressionState) throws EvaluationException {
        return new AccessorLValue(this, expressionState.getActiveContextObject(), expressionState.getEvaluationContext(), expressionState.getConfiguration().isAutoGrowNullReferences());
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        TypedValue typedValue = this.getValueInternal(expressionState.getActiveContextObject(), expressionState.getEvaluationContext(), expressionState.getConfiguration().isAutoGrowNullReferences());
        PropertyAccessor propertyAccessor = this.cachedReadAccessor;
        if (propertyAccessor instanceof CompilablePropertyAccessor) {
            CompilablePropertyAccessor compilablePropertyAccessor = (CompilablePropertyAccessor)propertyAccessor;
            this.setExitTypeDescriptor(CodeFlow.toDescriptor(compilablePropertyAccessor.getPropertyType()));
        }
        return typedValue;
    }

    private TypedValue getValueInternal(TypedValue typedValue, EvaluationContext evaluationContext, boolean bl2) throws EvaluationException {
        TypedValue typedValue2 = this.readProperty(typedValue, evaluationContext, this.name);
        if (typedValue2.getValue() == null && bl2 && this.nextChildIs(Indexer.class, PropertyOrFieldReference.class)) {
            TypeDescriptor typeDescriptor = typedValue2.getTypeDescriptor();
            Assert.state(typeDescriptor != null, "No result type");
            if (List.class == typeDescriptor.getType()) {
                if (this.isWritableProperty(this.name, typedValue, evaluationContext)) {
                    ArrayList arrayList = new ArrayList();
                    this.writeProperty(typedValue, evaluationContext, this.name, arrayList);
                    typedValue2 = this.readProperty(typedValue, evaluationContext, this.name);
                }
            } else if (Map.class == typeDescriptor.getType()) {
                if (this.isWritableProperty(this.name, typedValue, evaluationContext)) {
                    HashMap hashMap = new HashMap();
                    this.writeProperty(typedValue, evaluationContext, this.name, hashMap);
                    typedValue2 = this.readProperty(typedValue, evaluationContext, this.name);
                }
            } else {
                try {
                    if (this.isWritableProperty(this.name, typedValue, evaluationContext)) {
                        Class<?> clazz = typedValue2.getTypeDescriptor().getType();
                        Object obj = ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
                        this.writeProperty(typedValue, evaluationContext, this.name, obj);
                        typedValue2 = this.readProperty(typedValue, evaluationContext, this.name);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new SpelEvaluationException(this.getStartPosition(), invocationTargetException.getTargetException(), SpelMessage.UNABLE_TO_DYNAMICALLY_CREATE_OBJECT, typedValue2.getTypeDescriptor().getType());
                }
                catch (Throwable throwable) {
                    throw new SpelEvaluationException(this.getStartPosition(), throwable, SpelMessage.UNABLE_TO_DYNAMICALLY_CREATE_OBJECT, typedValue2.getTypeDescriptor().getType());
                }
            }
        }
        return typedValue2;
    }

    @Override
    public void setValue(ExpressionState expressionState, Object object) throws EvaluationException {
        this.writeProperty(expressionState.getActiveContextObject(), expressionState.getEvaluationContext(), this.name, object);
    }

    @Override
    public String toStringAST() {
        return this.name;
    }

    private TypedValue readProperty(TypedValue typedValue, EvaluationContext evaluationContext, String string) throws EvaluationException {
        Object object = typedValue.getValue();
        if (object == null && this.nullSafe) {
            return TypedValue.NULL;
        }
        PropertyAccessor propertyAccessor = this.cachedReadAccessor;
        if (propertyAccessor != null) {
            if (evaluationContext.getPropertyAccessors().contains(propertyAccessor)) {
                try {
                    return propertyAccessor.read(evaluationContext, typedValue.getValue(), string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cachedReadAccessor = null;
        }
        List<PropertyAccessor> list = this.getPropertyAccessorsToTry(typedValue.getValue(), evaluationContext.getPropertyAccessors());
        try {
            for (PropertyAccessor propertyAccessor2 : list) {
                if (!propertyAccessor2.canRead(evaluationContext, typedValue.getValue(), string)) continue;
                if (propertyAccessor2 instanceof ReflectivePropertyAccessor) {
                    propertyAccessor2 = ((ReflectivePropertyAccessor)propertyAccessor2).createOptimalAccessor(evaluationContext, typedValue.getValue(), string);
                }
                this.cachedReadAccessor = propertyAccessor2;
                return propertyAccessor2.read(evaluationContext, typedValue.getValue(), string);
            }
        }
        catch (Exception exception) {
            throw new SpelEvaluationException(exception, SpelMessage.EXCEPTION_DURING_PROPERTY_READ, string, exception.getMessage());
        }
        if (typedValue.getValue() == null) {
            throw new SpelEvaluationException(SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE_ON_NULL, string);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE, string, FormatHelper.formatClassNameForMessage(this.getObjectClass(typedValue.getValue())));
    }

    private void writeProperty(TypedValue typedValue, EvaluationContext evaluationContext, String string, Object object) throws EvaluationException {
        if (typedValue.getValue() == null && this.nullSafe) {
            return;
        }
        if (typedValue.getValue() == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE_ON_NULL, string);
        }
        PropertyAccessor propertyAccessor = this.cachedWriteAccessor;
        if (propertyAccessor != null) {
            if (evaluationContext.getPropertyAccessors().contains(propertyAccessor)) {
                try {
                    propertyAccessor.write(evaluationContext, typedValue.getValue(), string, object);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cachedWriteAccessor = null;
        }
        List<PropertyAccessor> list = this.getPropertyAccessorsToTry(typedValue.getValue(), evaluationContext.getPropertyAccessors());
        try {
            for (PropertyAccessor propertyAccessor2 : list) {
                if (!propertyAccessor2.canWrite(evaluationContext, typedValue.getValue(), string)) continue;
                this.cachedWriteAccessor = propertyAccessor2;
                propertyAccessor2.write(evaluationContext, typedValue.getValue(), string, object);
                return;
            }
        }
        catch (AccessException accessException) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)accessException, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, string, accessException.getMessage());
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE, string, FormatHelper.formatClassNameForMessage(this.getObjectClass(typedValue.getValue())));
    }

    public boolean isWritableProperty(String string, TypedValue typedValue, EvaluationContext evaluationContext) throws EvaluationException {
        Object object = typedValue.getValue();
        if (object != null) {
            List<PropertyAccessor> list = this.getPropertyAccessorsToTry(typedValue.getValue(), evaluationContext.getPropertyAccessors());
            for (PropertyAccessor propertyAccessor : list) {
                try {
                    if (!propertyAccessor.canWrite(evaluationContext, object, string)) continue;
                    return true;
                }
                catch (AccessException accessException) {
                }
            }
        }
        return false;
    }

    private List<PropertyAccessor> getPropertyAccessorsToTry(Object object, List<PropertyAccessor> list) {
        Class<?> clazz = object != null ? object.getClass() : null;
        ArrayList<PropertyAccessor> arrayList = new ArrayList<PropertyAccessor>();
        ArrayList<PropertyAccessor> arrayList2 = new ArrayList<PropertyAccessor>();
        block0: for (PropertyAccessor propertyAccessor : list) {
            Class<?>[] classArray = propertyAccessor.getSpecificTargetClasses();
            if (classArray == null) {
                arrayList2.add(propertyAccessor);
                continue;
            }
            if (clazz == null) continue;
            for (Class<?> clazz2 : classArray) {
                if (clazz2 == clazz) {
                    arrayList.add(propertyAccessor);
                    continue block0;
                }
                if (!clazz2.isAssignableFrom(clazz)) continue;
                arrayList2.add(propertyAccessor);
            }
        }
        ArrayList arrayList3 = new ArrayList(arrayList);
        arrayList2.removeAll(arrayList);
        arrayList3.addAll(arrayList2);
        return arrayList3;
    }

    @Override
    public boolean isCompilable() {
        PropertyAccessor propertyAccessor = this.cachedReadAccessor;
        return propertyAccessor instanceof CompilablePropertyAccessor && ((CompilablePropertyAccessor)propertyAccessor).isCompilable();
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        PropertyAccessor propertyAccessor = this.cachedReadAccessor;
        if (!(propertyAccessor instanceof CompilablePropertyAccessor)) {
            throw new IllegalStateException("Property accessor is not compilable: " + propertyAccessor);
        }
        Label label = null;
        if (this.nullSafe) {
            methodVisitor.visitInsn(89);
            label = new Label();
            Label label2 = new Label();
            methodVisitor.visitJumpInsn(199, label2);
            CodeFlow.insertCheckCast(methodVisitor, this.exitTypeDescriptor);
            methodVisitor.visitJumpInsn(167, label);
            methodVisitor.visitLabel(label2);
        }
        ((CompilablePropertyAccessor)propertyAccessor).generateCode(this.name, methodVisitor, codeFlow);
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
        if (this.originalPrimitiveExitTypeDescriptor != null) {
            CodeFlow.insertBoxIfNecessary(methodVisitor, this.originalPrimitiveExitTypeDescriptor);
        }
        if (label != null) {
            methodVisitor.visitLabel(label);
        }
    }

    void setExitTypeDescriptor(String string) {
        if (this.nullSafe && CodeFlow.isPrimitive(string)) {
            this.originalPrimitiveExitTypeDescriptor = string;
            this.exitTypeDescriptor = CodeFlow.toBoxedDescriptor(string);
        } else {
            this.exitTypeDescriptor = string;
        }
    }

    private static class AccessorLValue
    implements ValueRef {
        private final PropertyOrFieldReference ref;
        private final TypedValue contextObject;
        private final EvaluationContext evalContext;
        private final boolean autoGrowNullReferences;

        public AccessorLValue(PropertyOrFieldReference propertyOrFieldReference, TypedValue typedValue, EvaluationContext evaluationContext, boolean bl2) {
            this.ref = propertyOrFieldReference;
            this.contextObject = typedValue;
            this.evalContext = evaluationContext;
            this.autoGrowNullReferences = bl2;
        }

        @Override
        public TypedValue getValue() {
            TypedValue typedValue = this.ref.getValueInternal(this.contextObject, this.evalContext, this.autoGrowNullReferences);
            PropertyAccessor propertyAccessor = this.ref.cachedReadAccessor;
            if (propertyAccessor instanceof CompilablePropertyAccessor) {
                this.ref.setExitTypeDescriptor(CodeFlow.toDescriptor(((CompilablePropertyAccessor)propertyAccessor).getPropertyType()));
            }
            return typedValue;
        }

        @Override
        public void setValue(Object object) {
            this.ref.writeProperty(this.contextObject, this.evalContext, this.ref.name, object);
        }
    }
}

