/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.util;

import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class NumberUtils {
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final Set<Class<?>> STANDARD_NUMBER_TYPES;

    public static <T extends Number> T convertNumberToTargetClass(Number number, Class<T> clazz) throws IllegalArgumentException {
        Assert.notNull((Object)number, "Number must not be null");
        Assert.notNull(clazz, "Target class must not be null");
        if (clazz.isInstance(number)) {
            return (T)number;
        }
        if (Byte.class == clazz) {
            long l2 = NumberUtils.checkedLongValue(number, clazz);
            if (l2 < -128L || l2 > 127L) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return (T)Byte.valueOf(number.byteValue());
        }
        if (Short.class == clazz) {
            long l3 = NumberUtils.checkedLongValue(number, clazz);
            if (l3 < -32768L || l3 > 32767L) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return (T)Short.valueOf(number.shortValue());
        }
        if (Integer.class == clazz) {
            long l4 = NumberUtils.checkedLongValue(number, clazz);
            if (l4 < Integer.MIN_VALUE || l4 > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return (T)Integer.valueOf(number.intValue());
        }
        if (Long.class == clazz) {
            long l5 = NumberUtils.checkedLongValue(number, clazz);
            return (T)Long.valueOf(l5);
        }
        if (BigInteger.class == clazz) {
            if (number instanceof BigDecimal) {
                return (T)((BigDecimal)number).toBigInteger();
            }
            return (T)BigInteger.valueOf(number.longValue());
        }
        if (Float.class == clazz) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (Double.class == clazz) {
            return (T)Double.valueOf(number.doubleValue());
        }
        if (BigDecimal.class == clazz) {
            return (T)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unsupported target class [" + clazz.getName() + "]");
    }

    private static long checkedLongValue(Number number, Class<? extends Number> clazz) {
        BigInteger bigInteger = null;
        if (number instanceof BigInteger) {
            bigInteger = (BigInteger)number;
        } else if (number instanceof BigDecimal) {
            bigInteger = ((BigDecimal)number).toBigInteger();
        }
        if (bigInteger != null && (bigInteger.compareTo(LONG_MIN) < 0 || bigInteger.compareTo(LONG_MAX) > 0)) {
            NumberUtils.raiseOverflowException(number, clazz);
        }
        return number.longValue();
    }

    private static void raiseOverflowException(Number number, Class<?> clazz) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + clazz.getName() + "]: overflow");
    }

    public static <T extends Number> T parseNumber(String string, Class<T> clazz) {
        Assert.notNull((Object)string, "Text must not be null");
        Assert.notNull(clazz, "Target class must not be null");
        String string2 = StringUtils.trimAllWhitespace(string);
        if (Byte.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string2) ? Byte.decode(string2) : Byte.valueOf(string2));
        }
        if (Short.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string2) ? Short.decode(string2) : Short.valueOf(string2));
        }
        if (Integer.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string2) ? Integer.decode(string2) : Integer.valueOf(string2));
        }
        if (Long.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string2) ? Long.decode(string2) : Long.valueOf(string2));
        }
        if (BigInteger.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string2) ? NumberUtils.decodeBigInteger(string2) : new BigInteger(string2));
        }
        if (Float.class == clazz) {
            return (T)Float.valueOf(string2);
        }
        if (Double.class == clazz) {
            return (T)Double.valueOf(string2);
        }
        if (BigDecimal.class == clazz || Number.class == clazz) {
            return (T)new BigDecimal(string2);
        }
        throw new IllegalArgumentException("Cannot convert String [" + string + "] to target class [" + clazz.getName() + "]");
    }

    private static boolean isHexNumber(String string) {
        int n2 = string.startsWith("-") ? 1 : 0;
        return string.startsWith("0x", n2) || string.startsWith("0X", n2) || string.startsWith("#", n2);
    }

    private static BigInteger decodeBigInteger(String string) {
        int n2 = 10;
        int n3 = 0;
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        BigInteger bigInteger = new BigInteger(string.substring(n3), n2);
        return bl2 ? bigInteger.negate() : bigInteger;
    }

    static {
        HashSet<Class> hashSet = new HashSet<Class>(8);
        hashSet.add(Byte.class);
        hashSet.add(Short.class);
        hashSet.add(Integer.class);
        hashSet.add(Long.class);
        hashSet.add(BigInteger.class);
        hashSet.add(Float.class);
        hashSet.add(Double.class);
        hashSet.add(BigDecimal.class);
        STANDARD_NUMBER_TYPES = Collections.unmodifiableSet(hashSet);
    }
}

