/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.internal.changedetection.state.PropertyResourceBundleFallbackCharset;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.UnionResourceEntryFilter;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileAwareClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileAwareClasspathResourceHasher.class);
    private final ResourceHasher delegate;
    private final Map<PathMatcher, ResourceEntryFilter> propertiesFileFilters;
    private final List<String> propertiesFilePatterns;

    public PropertiesFileAwareClasspathResourceHasher(ResourceHasher resourceHasher, Map<String, ResourceEntryFilter> map) {
        this.delegate = resourceHasher;
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        map.forEach((string, resourceEntryFilter) -> {
            builder2.put(PatternMatcherFactory.compile(false, string), resourceEntryFilter);
            builder.add(string);
        });
        this.propertiesFileFilters = builder2.build();
        this.propertiesFilePatterns = builder.build();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
        this.propertiesFilePatterns.forEach(hasher::putString);
        this.propertiesFileFilters.values().forEach(resourceEntryFilter -> resourceEntryFilter.appendConfigurationToHasher(hasher));
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext regularFileSnapshotContext) throws IOException {
        HashCode hashCode;
        ResourceEntryFilter resourceEntryFilter = this.matchingFiltersFor(regularFileSnapshotContext.getRelativePathSegments());
        if (resourceEntryFilter == null) {
            return this.delegate.hash(regularFileSnapshotContext);
        }
        FileInputStream fileInputStream = new FileInputStream(regularFileSnapshotContext.getSnapshot().getAbsolutePath());
        try {
            hashCode = this.hashProperties(fileInputStream, resourceEntryFilter);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                LOGGER.debug("Could not load fingerprint for " + regularFileSnapshotContext.getSnapshot().getAbsolutePath() + ". Falling back to full entry fingerprinting", (Throwable)exception);
                return this.delegate.hash(regularFileSnapshotContext);
            }
        }
        fileInputStream.close();
        return hashCode;
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        ResourceEntryFilter resourceEntryFilter = this.matchingFiltersFor(zipEntryContext.getRelativePathSegments());
        if (resourceEntryFilter == null) {
            return this.delegate.hash(zipEntryContext);
        }
        try {
            return zipEntryContext.getEntry().withInputStream(inputStream -> this.hashProperties(inputStream, resourceEntryFilter));
        }
        catch (Exception exception) {
            LOGGER.debug("Could not load fingerprint for " + zipEntryContext.getRootParentName() + "!" + zipEntryContext.getFullName() + ". Falling back to full entry fingerprinting", (Throwable)exception);
            return this.delegate.hash(zipEntryContext);
        }
    }

    private ResourceEntryFilter matchingFiltersFor(Supplier<String[]> supplier) {
        List<ResourceEntryFilter> list = this.propertiesFileFilters.entrySet().stream().filter(entry -> ((PathMatcher)entry.getKey()).matches((String[])supplier.get(), 0)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (ResourceEntryFilter)list.get(0);
        }
        return new UnionResourceEntryFilter(list);
    }

    private HashCode hashProperties(InputStream inputStream, ResourceEntryFilter resourceEntryFilter) throws IOException {
        Hasher hasher = Hashing.newHasher();
        Properties properties = new Properties();
        properties.load(new InputStreamReader(inputStream, new PropertyResourceBundleFallbackCharset()));
        ImmutableMap<String, String> immutableMap = Maps.fromProperties(properties);
        immutableMap.entrySet().stream().filter(entry -> !resourceEntryFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            hasher.putString((CharSequence)entry.getKey());
            hasher.putString((CharSequence)entry.getValue());
        });
        return hasher.hash();
    }
}

