/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.TokenUtils;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.JWTParser;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Claim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.DecodedJWT;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Header;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Payload;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.List;

final class JWTDecoder
implements DecodedJWT,
Serializable {
    private final String[] parts;
    private final Header header;
    private final Payload payload;

    JWTDecoder(JWTParser jWTParser, String string) throws JWTDecodeException {
        String string2;
        String string3;
        this.parts = TokenUtils.splitToken(string);
        try {
            string3 = new String(Base64.getUrlDecoder().decode(this.parts[0]), StandardCharsets.UTF_8);
            string2 = new String(Base64.getUrlDecoder().decode(this.parts[1]), StandardCharsets.UTF_8);
        }
        catch (NullPointerException nullPointerException) {
            throw new JWTDecodeException("The UTF-8 Charset isn't initialized.", nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JWTDecodeException("The input is not a valid base 64 encoded string.", illegalArgumentException);
        }
        this.header = jWTParser.parseHeader(string3);
        this.payload = jWTParser.parsePayload(string2);
    }

    @Override
    public String getAlgorithm() {
        return this.header.getAlgorithm();
    }

    @Override
    public String getKeyId() {
        return this.header.getKeyId();
    }

    @Override
    public String getIssuer() {
        return this.payload.getIssuer();
    }

    @Override
    public String getSubject() {
        return this.payload.getSubject();
    }

    @Override
    public List<String> getAudience() {
        return this.payload.getAudience();
    }

    @Override
    public Date getExpiresAt() {
        return this.payload.getExpiresAt();
    }

    @Override
    public Date getNotBefore() {
        return this.payload.getNotBefore();
    }

    @Override
    public Date getIssuedAt() {
        return this.payload.getIssuedAt();
    }

    @Override
    public String getId() {
        return this.payload.getId();
    }

    @Override
    public Claim getClaim(String string) {
        return this.payload.getClaim(string);
    }

    @Override
    public String getHeader() {
        return this.parts[0];
    }

    @Override
    public String getPayload() {
        return this.parts[1];
    }

    @Override
    public String getSignature() {
        return this.parts[2];
    }

    @Override
    public String getToken() {
        return String.format("%s.%s.%s", this.parts[0], this.parts[1], this.parts[2]);
    }
}

