/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.reflect;

import com.gradle.maven.extension.internal.dep.com.google.common.reflect.Element;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.TypeToken;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

public abstract class Invokable<T, R>
extends Element
implements GenericDeclaration {
    <M extends AccessibleObject> Invokable(M m2) {
        super(m2);
    }

    public final Class<? super T> getDeclaringClass() {
        return super.getDeclaringClass();
    }

    public TypeToken<T> getOwnerType() {
        return TypeToken.of(this.getDeclaringClass());
    }

    abstract Type[] getGenericParameterTypes();

    static class ConstructorInvokable<T>
    extends Invokable<T, T> {
        final Constructor<?> constructor;

        ConstructorInvokable(Constructor<?> constructor) {
            super(constructor);
            this.constructor = constructor;
        }

        @Override
        Type[] getGenericParameterTypes() {
            Class<?>[] classArray;
            Type[] typeArray = this.constructor.getGenericParameterTypes();
            if (typeArray.length > 0 && this.mayNeedHiddenThis() && typeArray.length == (classArray = this.constructor.getParameterTypes()).length && classArray[0] == this.getDeclaringClass().getEnclosingClass()) {
                return Arrays.copyOfRange(typeArray, 1, typeArray.length);
            }
            return typeArray;
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            TypeVariable<Class<T>>[] typeVariableArray = this.getDeclaringClass().getTypeParameters();
            TypeVariable<Constructor<?>>[] typeVariableArray2 = this.constructor.getTypeParameters();
            TypeVariable[] typeVariableArray3 = new TypeVariable[typeVariableArray.length + typeVariableArray2.length];
            System.arraycopy(typeVariableArray, 0, typeVariableArray3, 0, typeVariableArray.length);
            System.arraycopy(typeVariableArray2, 0, typeVariableArray3, typeVariableArray.length, typeVariableArray2.length);
            return typeVariableArray3;
        }

        private boolean mayNeedHiddenThis() {
            Class<?> clazz = this.constructor.getDeclaringClass();
            if (clazz.getEnclosingConstructor() != null) {
                return true;
            }
            Method method = clazz.getEnclosingMethod();
            if (method != null) {
                return !Modifier.isStatic(method.getModifiers());
            }
            return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
        }
    }

    static class MethodInvokable<T>
    extends Invokable<T, Object> {
        final Method method;

        MethodInvokable(Method method) {
            super(method);
            this.method = method;
        }

        @Override
        Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            return this.method.getTypeParameters();
        }
    }
}

