/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.serialization;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.serialization.ClassNameMatcher;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.serialization.FullClassNameMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;

public class ValidatingObjectInputStream
extends ObjectInputStream {
    private final List<ClassNameMatcher> acceptMatchers = new ArrayList<ClassNameMatcher>();
    private final List<ClassNameMatcher> rejectMatchers = new ArrayList<ClassNameMatcher>();

    public ValidatingObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    private void validateClassName(String string) throws InvalidClassException {
        for (ClassNameMatcher object : this.rejectMatchers) {
            if (!object.matches(string)) continue;
            this.invalidClassNameFound(string);
        }
        boolean bl2 = false;
        for (ClassNameMatcher classNameMatcher : this.acceptMatchers) {
            if (!classNameMatcher.matches(string)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.invalidClassNameFound(string);
        }
    }

    protected void invalidClassNameFound(String string) throws InvalidClassException {
        throw new InvalidClassException("Class name not accepted: " + string);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        this.validateClassName(objectStreamClass.getName());
        return super.resolveClass(objectStreamClass);
    }

    public ValidatingObjectInputStream accept(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.acceptMatchers.add(new FullClassNameMatcher(clazz.getName()));
        }
        return this;
    }
}

