/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipInputStream;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.JdkZipEntry;
import org.gradle.internal.file.FileException;

public class StreamZipInput
implements ZipInput {
    private final ZipInputStream in;

    public StreamZipInput(InputStream inputStream) {
        this.in = new ZipInputStream(inputStream);
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            @Override
            protected ZipEntry computeNext() {
                java.util.zip.ZipEntry zipEntry;
                try {
                    zipEntry = StreamZipInput.this.in.getNextEntry();
                }
                catch (IOException iOException) {
                    throw new FileException(iOException);
                }
                return zipEntry == null ? (ZipEntry)this.endOfData() : new JdkZipEntry(zipEntry, new Supplier<InputStream>(){

                    @Override
                    public InputStream get() {
                        return StreamZipInput.this.in;
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StreamZipInput.this.in.closeEntry();
                        }
                        catch (IOException iOException) {
                            throw new FileException(iOException);
                        }
                    }
                });
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

