/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractDirectorySensitiveFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.RootTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class NameOnlyFingerprintingStrategy
extends AbstractDirectorySensitiveFingerprintingStrategy {
    public static final NameOnlyFingerprintingStrategy DEFAULT = new NameOnlyFingerprintingStrategy(DirectorySensitivity.DEFAULT);
    public static final NameOnlyFingerprintingStrategy IGNORE_DIRECTORIES = new NameOnlyFingerprintingStrategy(DirectorySensitivity.IGNORE_DIRECTORIES);
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public NameOnlyFingerprintingStrategy(DirectorySensitivity directorySensitivity, FileSystemLocationSnapshotHasher fileSystemLocationSnapshotHasher) {
        super("NAME_ONLY", directorySensitivity, fileSystemLocationSnapshotHasher);
        this.normalizedContentHasher = fileSystemLocationSnapshotHasher;
    }

    private NameOnlyFingerprintingStrategy(DirectorySensitivity directorySensitivity) {
        this(directorySensitivity, FileSystemLocationSnapshotHasher.DEFAULT);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot fileSystemSnapshot) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        final HashSet hashSet = new HashSet();
        fileSystemSnapshot.accept(new RootTrackingFileSystemSnapshotHierarchyVisitor(){

            @Override
            public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot fileSystemLocationSnapshot, boolean bl2) {
                String string = fileSystemLocationSnapshot.getAbsolutePath();
                if (hashSet.add(string) && NameOnlyFingerprintingStrategy.this.getDirectorySensitivity().shouldFingerprint(fileSystemLocationSnapshot)) {
                    if (bl2 && fileSystemLocationSnapshot.getType() == FileType.Directory) {
                        builder.put(string, IgnoredPathFileSystemLocationFingerprint.DIRECTORY);
                    } else {
                        HashCode hashCode = NameOnlyFingerprintingStrategy.this.getNormalizedContentHash(fileSystemLocationSnapshot, NameOnlyFingerprintingStrategy.this.normalizedContentHasher);
                        if (hashCode != null) {
                            builder.put(string, new DefaultFileSystemLocationFingerprint(fileSystemLocationSnapshot.getName(), fileSystemLocationSnapshot.getType(), hashCode));
                        }
                    }
                }
                return SnapshotVisitResult.CONTINUE;
            }
        });
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

