/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.FormatSchema;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JacksonException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.TreeNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.exc.StreamReadException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.filter.TokenFilter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DatabindException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.InjectableValues;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DataFormatReaders;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReader
extends ObjectCodec
implements Serializable {
    protected final DeserializationConfig _config;
    protected final DefaultDeserializationContext _context;
    protected final JsonFactory _parserFactory;
    protected final boolean _unwrapRoot;
    private final TokenFilter _filter;
    protected final JavaType _valueType;
    protected final JsonDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final DataFormatReaders _dataFormatReaders;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig) {
        this(objectMapper, deserializationConfig, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        this._config = deserializationConfig;
        this._context = objectMapper._deserializationContext;
        this._rootDeserializers = objectMapper._rootDeserializers;
        this._parserFactory = objectMapper._jsonFactory;
        this._valueType = javaType;
        this._valueToUpdate = object;
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(javaType);
        this._dataFormatReaders = null;
        this._filter = null;
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = javaType;
        this._rootDeserializer = jsonDeserializer;
        this._valueToUpdate = object;
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = dataFormatReaders;
        this._filter = objectReader._filter;
    }

    protected ObjectReader _new(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        return new ObjectReader(objectReader, deserializationConfig, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    protected JsonToken _initForReading(DeserializationContext deserializationContext, JsonParser jsonParser) throws IOException {
        this._config.initialize(jsonParser, this._schema);
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            deserializationContext.reportInputMismatch(this._valueType, "No content to map due to end-of-input", new Object[0]);
        }
        return jsonToken;
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, injectableValues, this._dataFormatReaders);
    }

    public ObjectReader forType(JavaType javaType) {
        if (javaType != null && javaType.equals(this._valueType)) {
            return this;
        }
        JsonDeserializer<Object> jsonDeserializer = this._prefetchRootDeserializer(javaType);
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            dataFormatReaders = dataFormatReaders.withType(javaType);
        }
        return this._new(this, this._config, javaType, jsonDeserializer, this._valueToUpdate, this._schema, this._injectableValues, dataFormatReaders);
    }

    public ObjectReader forType(Class<?> clazz) {
        return this.forType(this._config.constructType(clazz));
    }

    public ObjectReader forType(TypeReference<?> typeReference) {
        return this.forType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectReader withValueToUpdate(Object object) {
        if (object == this._valueToUpdate) {
            return this;
        }
        if (object == null) {
            return this._new(this, this._config, this._valueType, this._rootDeserializer, null, this._schema, this._injectableValues, this._dataFormatReaders);
        }
        JavaType javaType = this._valueType == null ? this._config.constructType(object.getClass()) : this._valueType;
        return this._new(this, this._config, javaType, this._rootDeserializer, object, this._schema, this._injectableValues, this._dataFormatReaders);
    }

    @Override
    public JsonFactory getFactory() {
        return this._parserFactory;
    }

    public JsonParser createParser(String string) throws IOException {
        this._assertNotNull("content", string);
        return this._config.initialize(this._parserFactory.createParser(string), this._schema);
    }

    public <T> T readValue(JsonParser jsonParser) throws IOException {
        this._assertNotNull("p", jsonParser);
        return (T)this._bind(jsonParser, this._valueToUpdate);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType(clazz).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<T> typeReference) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType(typeReference).readValue(jsonParser);
    }

    public JsonParser treeAsTokens(TreeNode treeNode) {
        this._assertNotNull("n", treeNode);
        ObjectReader objectReader = this.withValueToUpdate(null);
        return new TreeTraversingParser((JsonNode)treeNode, objectReader);
    }

    public <T> T readValue(String string) throws JsonProcessingException, JsonMappingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string);
        }
        try {
            return (T)this._bindAndClose(this._considerFilter(this.createParser(string), false));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) throws JsonProcessingException {
        this._assertNotNull("n", treeNode);
        try {
            return this.readValue(this.treeAsTokens(treeNode), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        throw new UnsupportedOperationException("Not implemented for ObjectReader");
    }

    protected Object _bind(JsonParser jsonParser, Object object) throws IOException {
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        JsonToken jsonToken = this._initForReading(defaultDeserializationContext, jsonParser);
        Object object2 = jsonToken == JsonToken.VALUE_NULL ? (object == null ? this._findRootDeserializer(defaultDeserializationContext).getNullValue(defaultDeserializationContext) : object) : (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT ? object : defaultDeserializationContext.readRootValue(jsonParser, this._valueType, this._findRootDeserializer(defaultDeserializationContext), this._valueToUpdate));
        jsonParser.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, this._valueType);
        }
        return object2;
    }

    protected Object _bindAndClose(JsonParser jsonParser) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser2);
            JsonToken jsonToken = this._initForReading(defaultDeserializationContext, jsonParser2);
            Object object = jsonToken == JsonToken.VALUE_NULL ? (this._valueToUpdate == null ? this._findRootDeserializer(defaultDeserializationContext).getNullValue(defaultDeserializationContext) : this._valueToUpdate) : (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT ? this._valueToUpdate : defaultDeserializationContext.readRootValue(jsonParser2, this._valueType, this._findRootDeserializer(defaultDeserializationContext), this._valueToUpdate));
            if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(jsonParser2, defaultDeserializationContext, this._valueType);
            }
            Object object2 = object;
            return object2;
        }
    }

    protected JsonParser _considerFilter(JsonParser jsonParser, boolean bl2) {
        return this._filter == null || FilteringParserDelegate.class.isInstance(jsonParser) ? jsonParser : new FilteringParserDelegate(jsonParser, this._filter, TokenFilter.Inclusion.ONLY_INCLUDE_ALL, bl2);
    }

    protected final void _verifyNoTrailingTokens(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != null) {
            Class<?> clazz = ClassUtil.rawClass(javaType);
            if (clazz == null && this._valueToUpdate != null) {
                clazz = this._valueToUpdate.getClass();
            }
            deserializationContext.reportTrailingTokens(clazz, jsonParser, jsonToken);
        }
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser) {
        return this._context.createInstance(this._config, jsonParser, this._injectableValues);
    }

    protected DefaultDeserializationContext createDummyDeserializationContext() {
        return this._context.createDummyInstance(this._config);
    }

    protected void _reportUndetectableSource(Object object) throws StreamReadException {
        throw new JsonParseException(null, "Cannot use source of type " + object.getClass().getName() + " with format auto-detection: must be byte- not char-based");
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext) throws DatabindException {
        JsonDeserializer<Object> jsonDeserializer;
        if (this._rootDeserializer != null) {
            return this._rootDeserializer;
        }
        JavaType javaType = this._valueType;
        if (javaType == null) {
            deserializationContext.reportBadDefinition((JavaType)null, "No value type configured for ObjectReader");
        }
        if ((jsonDeserializer = this._rootDeserializers.get(javaType)) != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            deserializationContext.reportBadDefinition(javaType, "Cannot find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _prefetchRootDeserializer(JavaType javaType) {
        if (javaType == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) {
            return null;
        }
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer == null) {
            try {
                DefaultDeserializationContext defaultDeserializationContext = this.createDummyDeserializationContext();
                jsonDeserializer = defaultDeserializationContext.findRootValueDeserializer(javaType);
                if (jsonDeserializer != null) {
                    this._rootDeserializers.put(javaType, jsonDeserializer);
                }
                return jsonDeserializer;
            }
            catch (JacksonException jacksonException) {
                // empty catch block
            }
        }
        return jsonDeserializer;
    }

    protected final void _assertNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", string));
        }
    }
}

