/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class OffsetTimeSerializer
extends JSR310FormattedSerializerBase<OffsetTime> {
    public static final OffsetTimeSerializer INSTANCE = new OffsetTimeSerializer();

    protected OffsetTimeSerializer() {
        super(OffsetTime.class);
    }

    protected OffsetTimeSerializer(OffsetTimeSerializer offsetTimeSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter) {
        this(offsetTimeSerializer, bl2, null, dateTimeFormatter);
    }

    protected OffsetTimeSerializer(OffsetTimeSerializer offsetTimeSerializer, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter) {
        super(offsetTimeSerializer, bl2, bl3, dateTimeFormatter, null);
    }

    protected OffsetTimeSerializer withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new OffsetTimeSerializer(this, bl2, dateTimeFormatter);
    }

    @Override
    public void serialize(OffsetTime offsetTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            jsonGenerator.writeStartArray();
            this._serializeAsArrayContents(offsetTime, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        } else {
            String string = this._formatter == null ? offsetTime.toString() : offsetTime.format(this._formatter);
            jsonGenerator.writeString(string);
        }
    }

    @Override
    public void serializeWithType(OffsetTime offsetTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(offsetTime, this.serializationShape(serializerProvider)));
        if (writableTypeId.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(offsetTime, jsonGenerator, serializerProvider);
        } else {
            String string = this._formatter == null ? offsetTime.toString() : offsetTime.format(this._formatter);
            jsonGenerator.writeString(string);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    private final void _serializeAsArrayContents(OffsetTime offsetTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(offsetTime.getHour());
        jsonGenerator.writeNumber(offsetTime.getMinute());
        int n2 = offsetTime.getSecond();
        int n3 = offsetTime.getNano();
        if (n2 > 0 || n3 > 0) {
            jsonGenerator.writeNumber(n2);
            if (n3 > 0) {
                if (this.useNanoseconds(serializerProvider)) {
                    jsonGenerator.writeNumber(n3);
                } else {
                    jsonGenerator.writeNumber(offsetTime.get(ChronoField.MILLI_OF_SECOND));
                }
            }
        }
        jsonGenerator.writeString(offsetTime.getOffset().toString());
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        return this.useTimestamp(serializerProvider) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean bl2, Boolean bl3) {
        return new OffsetTimeSerializer(this, this._useTimestamp, bl3, this._formatter);
    }
}

