/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.primitives.Booleans;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.Ints;
import java.util.Comparator;

public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE = new ComparisonChain(){

        public ComparisonChain compare(Comparable comparable, Comparable comparable2) {
            return this.classify(comparable.compareTo(comparable2));
        }

        @Override
        public <T> ComparisonChain compare(T t2, T t3, Comparator<T> comparator) {
            return this.classify(comparator.compare(t2, t3));
        }

        @Override
        public ComparisonChain compare(int n2, int n3) {
            return this.classify(Ints.compare(n2, n3));
        }

        @Override
        public ComparisonChain compareFalseFirst(boolean bl2, boolean bl3) {
            return this.classify(Booleans.compare(bl2, bl3));
        }

        ComparisonChain classify(int n2) {
            return n2 < 0 ? LESS : (n2 > 0 ? GREATER : ACTIVE);
        }

        @Override
        public int result() {
            return 0;
        }
    };
    private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
    private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

    private ComparisonChain() {
    }

    public static ComparisonChain start() {
        return ACTIVE;
    }

    public abstract ComparisonChain compare(Comparable<?> var1, Comparable<?> var2);

    public abstract <T> ComparisonChain compare(T var1, T var2, Comparator<T> var3);

    public abstract ComparisonChain compare(int var1, int var2);

    public abstract ComparisonChain compareFalseFirst(boolean var1, boolean var2);

    public abstract int result();

    private static final class InactiveComparisonChain
    extends ComparisonChain {
        final int result;

        InactiveComparisonChain(int n2) {
            this.result = n2;
        }

        public ComparisonChain compare(Comparable comparable, Comparable comparable2) {
            return this;
        }

        @Override
        public <T> ComparisonChain compare(T t2, T t3, Comparator<T> comparator) {
            return this;
        }

        @Override
        public ComparisonChain compare(int n2, int n3) {
            return this;
        }

        @Override
        public ComparisonChain compareFalseFirst(boolean bl2, boolean bl3) {
            return this;
        }

        @Override
        public int result() {
            return this.result;
        }
    }
}

