/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

class AppendableWriter
extends Writer {
    private final Appendable target;
    private boolean closed;

    AppendableWriter(Appendable appendable) {
        this.target = Preconditions.checkNotNull(appendable);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.checkNotClosed();
        this.target.append(new String(cArray, n2, n3));
    }

    @Override
    public void write(int n2) throws IOException {
        this.checkNotClosed();
        this.target.append((char)n2);
    }

    @Override
    public void write(String string) throws IOException {
        this.checkNotClosed();
        this.target.append(string);
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this.checkNotClosed();
        this.target.append(string, n2, n2 + n3);
    }

    @Override
    public void flush() throws IOException {
        this.checkNotClosed();
        if (this.target instanceof Flushable) {
            ((Flushable)((Object)this.target)).flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.target instanceof Closeable) {
            ((Closeable)((Object)this.target)).close();
        }
    }

    @Override
    public Writer append(char c2) throws IOException {
        this.checkNotClosed();
        this.target.append(c2);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.checkNotClosed();
        this.target.append(charSequence);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n2, int n3) throws IOException {
        this.checkNotClosed();
        this.target.append(charSequence, n2, n3);
        return this;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed writer.");
        }
    }
}

