/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.reflect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Function;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Joiner;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Objects;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Predicates;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.Reflection;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.TypeCapture;
import com.gradle.maven.extension.internal.dep.com.google.common.reflect.TypeVisitor;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class Types {
    private static final Function<Type, String> TYPE_NAME = new Function<Type, String>(){

        @Override
        public String apply(Type type) {
            return JavaVersion.CURRENT.typeName(type);
        }
    };
    private static final Joiner COMMA_JOINER = Joiner.on(", ").useForNull("null");

    static Type newArrayType(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getLowerBounds();
            Preconditions.checkArgument(typeArray.length <= 1, "Wildcard cannot have more than one lower bounds.");
            if (typeArray.length == 1) {
                return Types.supertypeOf(Types.newArrayType(typeArray[0]));
            }
            Type[] typeArray2 = wildcardType.getUpperBounds();
            Preconditions.checkArgument(typeArray2.length == 1, "Wildcard should have only one upper bound.");
            return Types.subtypeOf(Types.newArrayType(typeArray2[0]));
        }
        return JavaVersion.CURRENT.newArrayType(type);
    }

    static ParameterizedType newParameterizedTypeWithOwner(Type type, Class<?> clazz, Type ... typeArray) {
        if (type == null) {
            return Types.newParameterizedType(clazz, typeArray);
        }
        Preconditions.checkNotNull(typeArray);
        Preconditions.checkArgument(clazz.getEnclosingClass() != null, "Owner type for unenclosed %s", clazz);
        return new ParameterizedTypeImpl(type, clazz, typeArray);
    }

    static ParameterizedType newParameterizedType(Class<?> clazz, Type ... typeArray) {
        return new ParameterizedTypeImpl(ClassOwnership.JVM_BEHAVIOR.getOwnerType(clazz), clazz, typeArray);
    }

    static <D extends GenericDeclaration> TypeVariable<D> newArtificialTypeVariable(D d2, String string, Type ... typeArray) {
        Type[] typeArray2;
        if (typeArray.length == 0) {
            Type[] typeArray3 = new Type[1];
            typeArray2 = typeArray3;
            typeArray3[0] = Object.class;
        } else {
            typeArray2 = typeArray;
        }
        return Types.newTypeVariableImpl(d2, string, typeArray2);
    }

    static WildcardType subtypeOf(Type type) {
        return new WildcardTypeImpl(new Type[0], new Type[]{type});
    }

    static WildcardType supertypeOf(Type type) {
        return new WildcardTypeImpl(new Type[]{type}, new Type[]{Object.class});
    }

    static String toString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static Type getComponentType(Type type) {
        Preconditions.checkNotNull(type);
        final AtomicReference atomicReference = new AtomicReference();
        new TypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> typeVariable) {
                atomicReference.set(Types.subtypeOfComponentType(typeVariable.getBounds()));
            }

            @Override
            void visitWildcardType(WildcardType wildcardType) {
                atomicReference.set(Types.subtypeOfComponentType(wildcardType.getUpperBounds()));
            }

            @Override
            void visitGenericArrayType(GenericArrayType genericArrayType) {
                atomicReference.set(genericArrayType.getGenericComponentType());
            }

            @Override
            void visitClass(Class<?> clazz) {
                atomicReference.set(clazz.getComponentType());
            }
        }.visit(type);
        return (Type)atomicReference.get();
    }

    private static Type subtypeOfComponentType(Type[] typeArray) {
        for (Type type : typeArray) {
            Class clazz;
            Type type2 = Types.getComponentType(type);
            if (type2 == null) continue;
            if (type2 instanceof Class && (clazz = (Class)type2).isPrimitive()) {
                return clazz;
            }
            return Types.subtypeOf(type2);
        }
        return null;
    }

    private static <D extends GenericDeclaration> TypeVariable<D> newTypeVariableImpl(D d2, String string, Type[] typeArray) {
        TypeVariableImpl<D> typeVariableImpl = new TypeVariableImpl<D>(d2, string, typeArray);
        TypeVariable typeVariable = Reflection.newProxy(TypeVariable.class, new TypeVariableInvocationHandler(typeVariableImpl));
        return typeVariable;
    }

    private static Type[] toArray(Collection<Type> collection) {
        return collection.toArray(new Type[0]);
    }

    private static Iterable<Type> filterUpperBounds(Iterable<Type> iterable) {
        return Iterables.filter(iterable, Predicates.not(Predicates.equalTo(Object.class)));
    }

    private static void disallowPrimitiveType(Type[] typeArray, String string) {
        for (Type type : typeArray) {
            if (!(type instanceof Class)) continue;
            Class clazz = (Class)type;
            Preconditions.checkArgument(!clazz.isPrimitive(), "Primitive type '%s' used as %s", clazz, string);
        }
    }

    static Class<?> getArrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    static final class NativeTypeVariableEquals<X> {
        static final boolean NATIVE_TYPE_VARIABLE_ONLY = !NativeTypeVariableEquals.class.getTypeParameters()[0].equals(Types.newArtificialTypeVariable(NativeTypeVariableEquals.class, "X", new Type[0]));

        NativeTypeVariableEquals() {
        }
    }

    static enum JavaVersion {
        JAVA6{

            @Override
            GenericArrayType newArrayType(Type type) {
                return new GenericArrayTypeImpl(type);
            }

            @Override
            Type usedInGenericType(Type type) {
                Class clazz;
                Preconditions.checkNotNull(type);
                if (type instanceof Class && (clazz = (Class)type).isArray()) {
                    return new GenericArrayTypeImpl(clazz.getComponentType());
                }
                return type;
            }
        }
        ,
        JAVA7{

            @Override
            Type newArrayType(Type type) {
                if (type instanceof Class) {
                    return Types.getArrayClass((Class)type);
                }
                return new GenericArrayTypeImpl(type);
            }

            @Override
            Type usedInGenericType(Type type) {
                return Preconditions.checkNotNull(type);
            }
        }
        ,
        JAVA8{

            @Override
            Type newArrayType(Type type) {
                return JAVA7.newArrayType(type);
            }

            @Override
            Type usedInGenericType(Type type) {
                return JAVA7.usedInGenericType(type);
            }

            @Override
            String typeName(Type type) {
                try {
                    Method method = Type.class.getMethod("getTypeName", new Class[0]);
                    return (String)method.invoke((Object)type, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)"Type.getTypeName should be available in Java 8");
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
            }
        }
        ,
        JAVA9{

            @Override
            Type newArrayType(Type type) {
                return JAVA8.newArrayType(type);
            }

            @Override
            Type usedInGenericType(Type type) {
                return JAVA8.usedInGenericType(type);
            }

            @Override
            String typeName(Type type) {
                return JAVA8.typeName(type);
            }

            @Override
            boolean jdkTypeDuplicatesOwnerName() {
                return false;
            }
        };

        static final JavaVersion CURRENT;

        abstract Type newArrayType(Type var1);

        abstract Type usedInGenericType(Type var1);

        final ImmutableList<Type> usedInGenericType(Type[] typeArray) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Type type : typeArray) {
                builder.add(this.usedInGenericType(type));
            }
            return builder.build();
        }

        String typeName(Type type) {
            return Types.toString(type);
        }

        boolean jdkTypeDuplicatesOwnerName() {
            return true;
        }

        static {
            CURRENT = AnnotatedElement.class.isAssignableFrom(TypeVariable.class) ? (new TypeCapture<Map.Entry<String, int[][]>>(){}.capture().toString().contains("java.util.Map.java.util.Map") ? JAVA8 : JAVA9) : (new TypeCapture<int[]>(){}.capture() instanceof Class ? JAVA7 : JAVA6);
        }
    }

    static final class WildcardTypeImpl
    implements Serializable,
    WildcardType {
        private final ImmutableList<Type> lowerBounds;
        private final ImmutableList<Type> upperBounds;

        WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            Types.disallowPrimitiveType(typeArray, "lower bound for wildcard");
            Types.disallowPrimitiveType(typeArray2, "upper bound for wildcard");
            this.lowerBounds = JavaVersion.CURRENT.usedInGenericType(typeArray);
            this.upperBounds = JavaVersion.CURRENT.usedInGenericType(typeArray2);
        }

        @Override
        public Type[] getLowerBounds() {
            return Types.toArray(this.lowerBounds);
        }

        @Override
        public Type[] getUpperBounds() {
            return Types.toArray(this.upperBounds);
        }

        public boolean equals(Object object) {
            if (object instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)object;
                return this.lowerBounds.equals(Arrays.asList(wildcardType.getLowerBounds())) && this.upperBounds.equals(Arrays.asList(wildcardType.getUpperBounds()));
            }
            return false;
        }

        public int hashCode() {
            return this.lowerBounds.hashCode() ^ this.upperBounds.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("?");
            for (Type type : this.lowerBounds) {
                stringBuilder.append(" super ").append(JavaVersion.CURRENT.typeName(type));
            }
            for (Type type : Types.filterUpperBounds(this.upperBounds)) {
                stringBuilder.append(" extends ").append(JavaVersion.CURRENT.typeName(type));
            }
            return stringBuilder.toString();
        }
    }

    private static final class TypeVariableImpl<D extends GenericDeclaration> {
        private final D genericDeclaration;
        private final String name;
        private final ImmutableList<Type> bounds;

        TypeVariableImpl(D d2, String string, Type[] typeArray) {
            Types.disallowPrimitiveType(typeArray, "bound for type variable");
            this.genericDeclaration = (GenericDeclaration)Preconditions.checkNotNull(d2);
            this.name = Preconditions.checkNotNull(string);
            this.bounds = ImmutableList.copyOf(typeArray);
        }

        public D getGenericDeclaration() {
            return this.genericDeclaration;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.genericDeclaration.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY) {
                if (object != null && Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof TypeVariableInvocationHandler) {
                    TypeVariableInvocationHandler typeVariableInvocationHandler = (TypeVariableInvocationHandler)Proxy.getInvocationHandler(object);
                    TypeVariableImpl typeVariableImpl = typeVariableInvocationHandler.typeVariableImpl;
                    return this.name.equals(typeVariableImpl.getName()) && this.genericDeclaration.equals(typeVariableImpl.getGenericDeclaration()) && this.bounds.equals(typeVariableImpl.bounds);
                }
                return false;
            }
            if (object instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)object;
                return this.name.equals(typeVariable.getName()) && this.genericDeclaration.equals(typeVariable.getGenericDeclaration());
            }
            return false;
        }
    }

    private static final class TypeVariableInvocationHandler
    implements InvocationHandler {
        private static final ImmutableMap<String, Method> typeVariableMethods;
        private final TypeVariableImpl<?> typeVariableImpl;

        TypeVariableInvocationHandler(TypeVariableImpl<?> typeVariableImpl) {
            this.typeVariableImpl = typeVariableImpl;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            Method method2 = typeVariableMethods.get(string);
            if (method2 == null) {
                throw new UnsupportedOperationException(string);
            }
            try {
                return method2.invoke(this.typeVariableImpl, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }

        static {
            ImmutableMap.Builder<String, Method> builder = ImmutableMap.builder();
            for (Method method : TypeVariableImpl.class.getMethods()) {
                if (!method.getDeclaringClass().equals(TypeVariableImpl.class)) continue;
                try {
                    method.setAccessible(true);
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                builder.put(method.getName(), method);
            }
            typeVariableMethods = builder.build();
        }
    }

    private static final class ParameterizedTypeImpl
    implements Serializable,
    ParameterizedType {
        private final Type ownerType;
        private final ImmutableList<Type> argumentsList;
        private final Class<?> rawType;

        ParameterizedTypeImpl(Type type, Class<?> clazz, Type[] typeArray) {
            Preconditions.checkNotNull(clazz);
            Preconditions.checkArgument(typeArray.length == clazz.getTypeParameters().length);
            Types.disallowPrimitiveType(typeArray, "type parameter");
            this.ownerType = type;
            this.rawType = clazz;
            this.argumentsList = JavaVersion.CURRENT.usedInGenericType(typeArray);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return Types.toArray(this.argumentsList);
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.ownerType != null && JavaVersion.CURRENT.jdkTypeDuplicatesOwnerName()) {
                stringBuilder.append(JavaVersion.CURRENT.typeName(this.ownerType)).append('.');
            }
            return stringBuilder.append(this.rawType.getName()).append('<').append(COMMA_JOINER.join(Iterables.transform(this.argumentsList, TYPE_NAME))).append('>').toString();
        }

        public int hashCode() {
            return (this.ownerType == null ? 0 : this.ownerType.hashCode()) ^ this.argumentsList.hashCode() ^ this.rawType.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterizedType = (ParameterizedType)object;
            return this.getRawType().equals(parameterizedType.getRawType()) && Objects.equal(this.getOwnerType(), parameterizedType.getOwnerType()) && Arrays.equals(this.getActualTypeArguments(), parameterizedType.getActualTypeArguments());
        }
    }

    private static final class GenericArrayTypeImpl
    implements Serializable,
    GenericArrayType {
        private final Type componentType;

        GenericArrayTypeImpl(Type type) {
            this.componentType = JavaVersion.CURRENT.usedInGenericType(type);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public String toString() {
            return String.valueOf(Types.toString(this.componentType)).concat("[]");
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)object;
                return Objects.equal(this.getGenericComponentType(), genericArrayType.getGenericComponentType());
            }
            return false;
        }
    }

    private static enum ClassOwnership {
        OWNED_BY_ENCLOSING_CLASS{

            @Override
            Class<?> getOwnerType(Class<?> clazz) {
                return clazz.getEnclosingClass();
            }
        }
        ,
        LOCAL_CLASS_HAS_NO_OWNER{

            @Override
            Class<?> getOwnerType(Class<?> clazz) {
                if (clazz.isLocalClass()) {
                    return null;
                }
                return clazz.getEnclosingClass();
            }
        };

        static final ClassOwnership JVM_BEHAVIOR;

        abstract Class<?> getOwnerType(Class<?> var1);

        private static ClassOwnership detectJvmBehavior() {
            class LocalClass<T> {
                LocalClass() {
                }
            }
            Class<?> clazz = new LocalClass<String>(){
                {
                }
            }.getClass();
            ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
            for (ClassOwnership classOwnership : ClassOwnership.values()) {
                if (classOwnership.getOwnerType(LocalClass.class) != parameterizedType.getOwnerType()) continue;
                return classOwnership;
            }
            throw new AssertionError();
        }

        static {
            JVM_BEHAVIOR = ClassOwnership.detectJvmBehavior();
        }
    }
}

