/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.AbstractConnectionPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ConnectionPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ProxyConfiguration;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.RequestNotifier;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ResponseNotifier;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.SendFailure;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Destination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ClientConnectionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.CyclicTimeouts;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BlockingArrayQueue;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.HostPort;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Sweeper;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;

public abstract class HttpDestination
extends ContainerLifeCycle
implements Closeable,
Destination,
Callback {
    private static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final HttpClient client;
    private final Origin origin;
    private final Queue<HttpExchange> exchanges;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final ProxyConfiguration.Proxy proxy;
    private final ClientConnectionFactory connectionFactory;
    private final HttpField hostField;
    private final RequestTimeouts requestTimeouts;
    private ConnectionPool connectionPool;

    public HttpDestination(HttpClient httpClient, Origin origin) {
        Object object;
        this.client = httpClient;
        this.origin = origin;
        this.exchanges = this.newExchangeQueue(httpClient);
        this.requestNotifier = new RequestNotifier(httpClient);
        this.responseNotifier = new ResponseNotifier();
        this.requestTimeouts = new RequestTimeouts(httpClient.getScheduler());
        ProxyConfiguration proxyConfiguration = httpClient.getProxyConfiguration();
        this.proxy = proxyConfiguration.match(origin);
        ClientConnectionFactory clientConnectionFactory = httpClient.getTransport();
        if (this.proxy != null) {
            clientConnectionFactory = this.proxy.newClientConnectionFactory(clientConnectionFactory);
            if (this.proxy.isSecure()) {
                clientConnectionFactory = this.newSslClientConnectionFactory(this.proxy.getSslContextFactory(), clientConnectionFactory);
            }
        } else if (this.isSecure()) {
            clientConnectionFactory = this.newSslClientConnectionFactory(null, clientConnectionFactory);
        }
        if ((object = origin.getTag()) instanceof ClientConnectionFactory.Decorator) {
            clientConnectionFactory = ((ClientConnectionFactory.Decorator)object).apply(clientConnectionFactory);
        }
        this.connectionFactory = clientConnectionFactory;
        String string = HostPort.normalizeHost(this.getHost());
        if (!httpClient.isDefaultPort(this.getScheme(), this.getPort())) {
            string = string + ":" + this.getPort();
        }
        this.hostField = new HttpField(HttpHeader.HOST, string);
    }

    @Override
    protected void doStart() throws Exception {
        this.connectionPool = this.newConnectionPool(this.client);
        this.addBean(this.connectionPool, true);
        super.doStart();
        Sweeper sweeper = this.client.getBean(Sweeper.class);
        if (sweeper != null && this.connectionPool instanceof Sweeper.Sweepable) {
            sweeper.offer((Sweeper.Sweepable)((Object)this.connectionPool));
        }
    }

    @Override
    protected void doStop() throws Exception {
        Sweeper sweeper = this.client.getBean(Sweeper.class);
        if (sweeper != null && this.connectionPool instanceof Sweeper.Sweepable) {
            sweeper.remove((Sweeper.Sweepable)((Object)this.connectionPool));
        }
        super.doStop();
        this.removeBean(this.connectionPool);
    }

    protected ConnectionPool newConnectionPool(HttpClient httpClient) {
        return httpClient.getTransport().getConnectionPoolFactory().newConnectionPool(this);
    }

    protected Queue<HttpExchange> newExchangeQueue(HttpClient httpClient) {
        return new BlockingArrayQueue<HttpExchange>(httpClient.getMaxRequestsQueuedPerDestination());
    }

    @Deprecated
    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory clientConnectionFactory) {
        return this.client.newSslClientConnectionFactory(null, clientConnectionFactory);
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory clientConnectionFactory) {
        if (sslContextFactory == null) {
            return this.newSslClientConnectionFactory(clientConnectionFactory);
        }
        return this.client.newSslClientConnectionFactory(sslContextFactory, clientConnectionFactory);
    }

    public boolean isSecure() {
        return HttpClient.isSchemeSecure(this.getScheme());
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Queue<HttpExchange> getHttpExchanges() {
        return this.exchanges;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public ResponseNotifier getResponseNotifier() {
        return this.responseNotifier;
    }

    public ProxyConfiguration.Proxy getProxy() {
        return this.proxy;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    public String getScheme() {
        return this.origin.getScheme();
    }

    public String getHost() {
        return this.origin.getAddress().getHost();
    }

    public int getPort() {
        return this.origin.getAddress().getPort();
    }

    public int getQueuedRequestCount() {
        return this.exchanges.size();
    }

    public Origin.Address getConnectAddress() {
        return this.proxy == null ? this.origin.getAddress() : this.proxy.getAddress();
    }

    public HttpField getHostField() {
        return this.hostField;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public void succeeded() {
        this.send(false);
    }

    @Override
    public void failed(Throwable throwable) {
        this.abort(throwable);
    }

    protected void send(HttpRequest httpRequest, List<Response.ResponseListener> list) {
        this.send(new HttpExchange(this, httpRequest, list));
    }

    public void send(HttpExchange httpExchange) {
        HttpRequest httpRequest = httpExchange.getRequest();
        if (this.client.isRunning()) {
            if (this.enqueue(this.exchanges, httpExchange)) {
                this.requestTimeouts.schedule(httpExchange);
                if (!this.client.isRunning() && this.exchanges.remove(httpExchange)) {
                    httpRequest.abort(new RejectedExecutionException(this.client + " is stopping"));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Queued {} for {}", httpRequest, this);
                    }
                    this.requestNotifier.notifyQueued(httpRequest);
                    this.send();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Max queue size {} exceeded by {} for {}", this.client.getMaxRequestsQueuedPerDestination(), httpRequest, this);
                }
                httpRequest.abort(new RejectedExecutionException("Max requests queued per destination " + this.client.getMaxRequestsQueuedPerDestination() + " exceeded for " + this));
            }
        } else {
            httpRequest.abort(new RejectedExecutionException(this.client + " is stopped"));
        }
    }

    protected boolean enqueue(Queue<HttpExchange> queue, HttpExchange httpExchange) {
        return queue.offer(httpExchange);
    }

    public void send() {
        this.send(true);
    }

    private void send(boolean bl2) {
        if (!this.getHttpExchanges().isEmpty()) {
            this.process(bl2);
        }
    }

    private void process(boolean bl2) {
        boolean bl3;
        Connection connection;
        while ((connection = this.connectionPool instanceof AbstractConnectionPool ? ((AbstractConnectionPool)this.connectionPool).acquire(bl2) : this.connectionPool.acquire()) != null && (bl3 = this.process(connection))) {
            bl2 = false;
        }
    }

    private boolean process(Connection connection) {
        HttpClient httpClient = this.getHttpClient();
        HttpExchange httpExchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", httpExchange, connection, this);
        }
        if (httpExchange == null) {
            if (!this.connectionPool.release(connection)) {
                connection.close();
            }
            if (!httpClient.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", httpClient);
                }
                connection.close();
            }
            return false;
        }
        HttpRequest httpRequest = httpExchange.getRequest();
        Throwable throwable = httpRequest.getAbortCause();
        if (throwable != null) {
            boolean bl2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", httpExchange, throwable);
            }
            if (!(bl2 = this.connectionPool.release(connection))) {
                connection.close();
            }
            httpExchange.abort(throwable);
            return this.getQueuedRequestCount() > 0;
        }
        SendFailure sendFailure = this.send(connection, httpExchange);
        if (sendFailure == null) {
            return this.getQueuedRequestCount() > 0;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send failed {} for {}", sendFailure, httpExchange);
        }
        if (sendFailure.retry) {
            this.send(httpExchange);
            return false;
        }
        httpRequest.abort(sendFailure.failure);
        return this.getQueuedRequestCount() > 0;
    }

    protected abstract SendFailure send(Connection var1, HttpExchange var2);

    @Override
    public void newConnection(Promise<Connection> promise) {
        this.createConnection(promise);
    }

    protected void createConnection(Promise<Connection> promise) {
        this.client.newConnection(this, promise);
    }

    public boolean remove(HttpExchange httpExchange) {
        return this.exchanges.remove(httpExchange);
    }

    @Override
    public void close() {
        this.abort(new AsynchronousCloseException());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed {}", this);
        }
        this.connectionPool.close();
        this.requestTimeouts.destroy();
    }

    public void release(Connection connection) {
        HttpClient httpClient;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", connection);
        }
        if ((httpClient = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                if (this.connectionPool.release(connection)) {
                    this.send(false);
                } else {
                    connection.close();
                    this.send(true);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Released explicit {}", connection);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", httpClient);
            }
            connection.close();
        }
    }

    public boolean remove(Connection connection) {
        boolean bl2 = this.connectionPool.remove(connection);
        if (this.getHttpExchanges().isEmpty()) {
            this.tryRemoveIdleDestination();
        } else if (bl2) {
            this.send(true);
        }
        return bl2;
    }

    public void abort(Throwable throwable) {
        for (HttpExchange httpExchange : new ArrayList<HttpExchange>(this.exchanges)) {
            httpExchange.getRequest().abort(throwable);
        }
        if (this.exchanges.isEmpty()) {
            this.tryRemoveIdleDestination();
        }
    }

    private void tryRemoveIdleDestination() {
        if (this.getHttpClient().isRemoveIdleDestinations() && this.connectionPool.isEmpty()) {
            this.getHttpClient().removeDestination(this);
        }
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        this.dumpObjects(appendable, string, new DumpableCollection("exchanges", this.exchanges));
    }

    public String asString() {
        return this.origin.asString();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]@%x%s,queue=%d,pool=%s", HttpDestination.class.getSimpleName(), this.asString(), this.hashCode(), this.proxy == null ? "" : "(via " + this.proxy + ")", this.getQueuedRequestCount(), this.getConnectionPool());
    }

    private class RequestTimeouts
    extends CyclicTimeouts<HttpExchange> {
        private RequestTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        @Override
        protected Iterator<HttpExchange> iterator() {
            return HttpDestination.this.exchanges.iterator();
        }

        @Override
        protected boolean onExpired(HttpExchange httpExchange) {
            HttpRequest httpRequest = httpExchange.getRequest();
            httpRequest.abort(new TimeoutException("Total timeout " + httpRequest.getConversation().getTimeout() + " ms elapsed"));
            return false;
        }
    }
}

