/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpReceiver;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpResponseException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.BadMessageException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpParser;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.RetainableByteBuffer;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.LongAdder;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler {
    private final LongAdder inMessages = new LongAdder();
    private final HttpParser parser;
    private RetainableByteBuffer networkBuffer;
    private boolean shutdown;
    private boolean complete;
    private boolean unsolicited;
    private String method;
    private int status;

    public HttpReceiverOverHTTP(HttpChannelOverHTTP httpChannelOverHTTP) {
        super(httpChannelOverHTTP);
        this.parser = new HttpParser(this, -1, httpChannelOverHTTP.getHttpDestination().getHttpClient().getHttpCompliance());
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    @Override
    public void receive() {
        if (this.networkBuffer == null) {
            this.acquireNetworkBuffer();
        }
        this.process();
    }

    private void acquireNetworkBuffer() {
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquired {}", this.networkBuffer);
        }
    }

    private void reacquireNetworkBuffer() {
        RetainableByteBuffer retainableByteBuffer = this.networkBuffer;
        if (retainableByteBuffer == null) {
            throw new IllegalStateException();
        }
        if (retainableByteBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        retainableByteBuffer.release();
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reacquired {} <- {}", retainableByteBuffer, this.networkBuffer);
        }
    }

    private RetainableByteBuffer newNetworkBuffer() {
        HttpClient httpClient = this.getHttpDestination().getHttpClient();
        ByteBufferPool byteBufferPool = httpClient.getByteBufferPool();
        return new RetainableByteBuffer(byteBufferPool, httpClient.getResponseBufferSize(), true);
    }

    private void releaseNetworkBuffer() {
        if (this.networkBuffer == null) {
            return;
        }
        this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", this.networkBuffer);
        }
        this.networkBuffer = null;
    }

    protected ByteBuffer onUpgradeFrom() {
        RetainableByteBuffer retainableByteBuffer = this.networkBuffer;
        if (retainableByteBuffer == null) {
            return null;
        }
        ByteBuffer byteBuffer = null;
        if (retainableByteBuffer.hasRemaining()) {
            byteBuffer = BufferUtil.allocate(retainableByteBuffer.remaining());
            BufferUtil.clearToFill(byteBuffer);
            BufferUtil.put(retainableByteBuffer.getBuffer(), byteBuffer);
            BufferUtil.flipToFlush(byteBuffer, 0);
        }
        this.releaseNetworkBuffer();
        return byteBuffer;
    }

    private void process() {
        try {
            int n2;
            HttpConnectionOverHTTP httpConnectionOverHTTP = this.getHttpConnection();
            EndPoint endPoint = httpConnectionOverHTTP.getEndPoint();
            while (true) {
                if (this.parse()) {
                    return;
                }
                if (httpConnectionOverHTTP.isClosed()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closed {}", httpConnectionOverHTTP);
                    }
                    this.releaseNetworkBuffer();
                    return;
                }
                if (this.networkBuffer.getReferences() > 1) {
                    this.reacquireNetworkBuffer();
                }
                n2 = endPoint.fill(this.networkBuffer.getBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes in {} from {}", n2, this.networkBuffer, endPoint);
                }
                if (n2 <= 0) break;
                httpConnectionOverHTTP.addBytesIn(n2);
            }
            if (n2 == 0) {
                this.releaseNetworkBuffer();
                this.fillInterested();
                return;
            }
            this.releaseNetworkBuffer();
            this.shutdown();
            return;
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            this.releaseNetworkBuffer();
            this.failAndClose(throwable);
            return;
        }
    }

    private boolean parse() {
        boolean bl2;
        do {
            boolean bl3 = this.parser.parseNext(this.networkBuffer.getBuffer());
            boolean bl4 = this.isFailed();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse result={}, failed={}", bl3, bl4);
            }
            if (bl4) {
                this.parser.close();
            }
            if (bl3) {
                return !bl4;
            }
            bl2 = this.complete;
            this.complete = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse complete={}, {} {}", bl2, this.networkBuffer, this.parser);
            }
            if (bl2) {
                int n2 = this.status;
                this.status = 0;
                if (n2 == 101) {
                    return true;
                }
                String string = this.method;
                this.method = null;
                if (this.getHttpChannel().isTunnel(string, n2)) {
                    return true;
                }
            }
            if (!this.networkBuffer.isEmpty()) continue;
            return false;
        } while (!bl2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarding unexpected content after response: {}", this.networkBuffer);
        }
        this.networkBuffer.clear();
        return false;
    }

    protected void fillInterested() {
        this.getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public int getHeaderCacheSize() {
        HttpClientTransportOverHTTP httpClientTransportOverHTTP = (HttpClientTransportOverHTTP)this.getHttpDestination().getHttpClient().getTransport();
        return httpClientTransportOverHTTP.getHeaderCacheSize();
    }

    @Override
    public boolean startResponse(HttpVersion httpVersion, int n2, String string) {
        HttpExchange httpExchange = this.getHttpExchange();
        boolean bl2 = this.unsolicited = httpExchange == null;
        if (httpExchange == null) {
            return false;
        }
        this.method = httpExchange.getRequest().getMethod();
        this.status = n2;
        this.parser.setHeadResponse(HttpMethod.HEAD.is(this.method) || this.getHttpChannel().isTunnel(this.method, n2));
        httpExchange.getResponse().version(httpVersion).status(n2).reason(string);
        return !this.responseBegin(httpExchange);
    }

    @Override
    public void parsedHeader(HttpField httpField) {
        HttpExchange httpExchange = this.getHttpExchange();
        this.unsolicited |= httpExchange == null;
        if (this.unsolicited) {
            return;
        }
        this.responseHeader(httpExchange, httpField);
    }

    @Override
    public boolean headerComplete() {
        HttpExchange httpExchange = this.getHttpExchange();
        this.unsolicited |= httpExchange == null;
        if (this.unsolicited) {
            return false;
        }
        return !this.responseHeaders(httpExchange);
    }

    @Override
    public boolean content(ByteBuffer byteBuffer) {
        HttpExchange httpExchange = this.getHttpExchange();
        this.unsolicited |= httpExchange == null;
        if (this.unsolicited) {
            return false;
        }
        RetainableByteBuffer retainableByteBuffer = this.networkBuffer;
        retainableByteBuffer.retain();
        return !this.responseContent(httpExchange, byteBuffer, Callback.from(retainableByteBuffer::release, throwable -> {
            retainableByteBuffer.release();
            this.failAndClose((Throwable)throwable);
        }));
    }

    @Override
    public boolean contentComplete() {
        return false;
    }

    @Override
    public void parsedTrailer(HttpField httpField) {
        HttpExchange httpExchange = this.getHttpExchange();
        this.unsolicited |= httpExchange == null;
        if (this.unsolicited) {
            return;
        }
        httpExchange.getResponse().trailer(httpField);
    }

    @Override
    public boolean messageComplete() {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange == null || this.unsolicited) {
            this.getHttpConnection().close();
            return false;
        }
        int n2 = httpExchange.getResponse().getStatus();
        if (n2 != 100) {
            this.inMessages.increment();
            this.complete = true;
        }
        return !this.responseSuccess(httpExchange);
    }

    @Override
    public void earlyEOF() {
        HttpExchange httpExchange = this.getHttpExchange();
        HttpConnectionOverHTTP httpConnectionOverHTTP = this.getHttpConnection();
        if (httpExchange == null || this.unsolicited) {
            httpConnectionOverHTTP.close();
        } else {
            this.failAndClose(new EOFException(String.valueOf(httpConnectionOverHTTP)));
        }
    }

    @Override
    public void badMessage(BadMessageException badMessageException) {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange == null || this.unsolicited) {
            this.getHttpConnection().close();
        } else {
            HttpResponse httpResponse = httpExchange.getResponse();
            httpResponse.status(badMessageException.getCode()).reason(badMessageException.getReason());
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response on " + this.getHttpConnection(), httpResponse, badMessageException));
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
    }

    private void failAndClose(Throwable throwable) {
        if (this.responseFailure(throwable)) {
            this.getHttpConnection().close(throwable);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.parser);
    }
}

