/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ConstructorExecutor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ConstructorResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.ExpressionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelNode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.FormatHelper;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.InlineList;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.TypeCode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectiveConstructorExecutor;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ConstructorReference
extends SpelNodeImpl {
    private final boolean isArrayConstructor;
    private SpelNodeImpl[] dimensions;
    private volatile ConstructorExecutor cachedExecutor;

    public ConstructorReference(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(n2, n3, spelNodeImplArray);
        this.isArrayConstructor = false;
    }

    public ConstructorReference(int n2, int n3, SpelNodeImpl[] spelNodeImplArray, SpelNodeImpl ... spelNodeImplArray2) {
        super(n2, n3, spelNodeImplArray2);
        this.isArrayConstructor = true;
        this.dimensions = spelNodeImplArray;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.isArrayConstructor) {
            return this.createArray(expressionState);
        }
        return this.createNewInstance(expressionState);
    }

    private TypedValue createNewInstance(ExpressionState expressionState) throws EvaluationException {
        Object object;
        Object object2;
        Object[] objectArray = new Object[this.getChildCount() - 1];
        ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>(this.getChildCount() - 1);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            object2 = this.children[i2 + 1].getValueInternal(expressionState);
            objectArray[i2] = object = ((TypedValue)object2).getValue();
            arrayList.add(TypeDescriptor.forObject(object));
        }
        ConstructorExecutor constructorExecutor = this.cachedExecutor;
        if (constructorExecutor != null) {
            try {
                return constructorExecutor.execute(expressionState.getEvaluationContext(), objectArray);
            }
            catch (AccessException accessException) {
                if (accessException.getCause() instanceof InvocationTargetException) {
                    object = accessException.getCause().getCause();
                    if (object instanceof RuntimeException) {
                        throw (RuntimeException)object;
                    }
                    String string = (String)this.children[0].getValueInternal(expressionState).getValue();
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)object, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, string, FormatHelper.formatMethodForMessage("", arrayList));
                }
                this.cachedExecutor = null;
            }
        }
        Assert.state((object2 = (String)this.children[0].getValueInternal(expressionState).getValue()) != null, "No type name");
        constructorExecutor = this.findExecutorForConstructor((String)object2, arrayList, expressionState);
        try {
            this.cachedExecutor = constructorExecutor;
            if (constructorExecutor instanceof ReflectiveConstructorExecutor) {
                this.exitTypeDescriptor = CodeFlow.toDescriptor(((ReflectiveConstructorExecutor)constructorExecutor).getConstructor().getDeclaringClass());
            }
            return constructorExecutor.execute(expressionState.getEvaluationContext(), objectArray);
        }
        catch (AccessException accessException) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)accessException, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, object2, FormatHelper.formatMethodForMessage("", arrayList));
        }
    }

    private ConstructorExecutor findExecutorForConstructor(String string, List<TypeDescriptor> list, ExpressionState expressionState) throws SpelEvaluationException {
        EvaluationContext evaluationContext = expressionState.getEvaluationContext();
        List<ConstructorResolver> list2 = evaluationContext.getConstructorResolvers();
        for (ConstructorResolver constructorResolver : list2) {
            try {
                ConstructorExecutor constructorExecutor = constructorResolver.resolve(expressionState.getEvaluationContext(), string, list);
                if (constructorExecutor == null) continue;
                return constructorExecutor;
            }
            catch (AccessException accessException) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)accessException, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, string, FormatHelper.formatMethodForMessage("", list));
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CONSTRUCTOR_NOT_FOUND, string, FormatHelper.formatMethodForMessage("", list));
    }

    @Override
    public String toStringAST() {
        StringBuilder stringBuilder = new StringBuilder("new ");
        int n2 = 0;
        stringBuilder.append(this.getChild(n2++).toStringAST());
        stringBuilder.append('(');
        for (int i2 = n2; i2 < this.getChildCount(); ++i2) {
            if (i2 > n2) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.getChild(i2).toStringAST());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private TypedValue createArray(ExpressionState expressionState) throws EvaluationException {
        Object object = this.getChild(0).getValue(expressionState);
        if (!(object instanceof String)) {
            throw new SpelEvaluationException(this.getChild(0).getStartPosition(), SpelMessage.TYPE_NAME_EXPECTED_FOR_ARRAY_CONSTRUCTION, FormatHelper.formatClassNameForMessage(object != null ? object.getClass() : null));
        }
        String string = (String)object;
        TypeCode typeCode = TypeCode.forName(string);
        Class<?> clazz = typeCode == TypeCode.OBJECT ? expressionState.findType(string) : typeCode.getType();
        Object object2 = null;
        if (!this.hasInitializer()) {
            if (this.dimensions != null) {
                for (SpelNodeImpl n4 : this.dimensions) {
                    if (n4 != null) continue;
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MISSING_ARRAY_DIMENSION, new Object[0]);
                }
                TypeConverter typeConverter = expressionState.getEvaluationContext().getTypeConverter();
                if (this.dimensions.length == 1) {
                    TypedValue nArray = this.dimensions[0].getTypedValue(expressionState);
                    int l2 = ExpressionUtils.toInt(typeConverter, nArray);
                    this.checkNumElements(l2);
                    object2 = Array.newInstance(clazz, l2);
                } else {
                    int[] inlineList = new int[this.dimensions.length];
                    long typedValue = 1L;
                    for (int i2 = 0; i2 < this.dimensions.length; ++i2) {
                        int n2;
                        TypedValue typedValue2 = this.dimensions[i2].getTypedValue(expressionState);
                        inlineList[i2] = n2 = ExpressionUtils.toInt(typeConverter, typedValue2);
                        this.checkNumElements(typedValue *= (long)n2);
                    }
                    object2 = Array.newInstance(clazz, inlineList);
                }
            }
        } else {
            TypedValue n5;
            int n3;
            if (this.dimensions == null || this.dimensions.length > 1) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MULTIDIM_ARRAY_INITIALIZER_NOT_SUPPORTED, new Object[0]);
            }
            TypeConverter typeConverter = expressionState.getEvaluationContext().getTypeConverter();
            InlineList inlineList = (InlineList)this.getChild(1);
            if (this.dimensions[0] != null && (n3 = ExpressionUtils.toInt(typeConverter, n5 = this.dimensions[0].getTypedValue(expressionState))) != inlineList.getChildCount()) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INITIALIZER_LENGTH_INCORRECT, new Object[0]);
            }
            int n4 = inlineList.getChildCount();
            object2 = Array.newInstance(clazz, n4);
            if (typeCode == TypeCode.OBJECT) {
                this.populateReferenceTypeArray(expressionState, object2, typeConverter, inlineList, clazz);
            } else if (typeCode == TypeCode.BOOLEAN) {
                this.populateBooleanArray(expressionState, object2, typeConverter, inlineList);
            } else if (typeCode == TypeCode.BYTE) {
                this.populateByteArray(expressionState, object2, typeConverter, inlineList);
            } else if (typeCode == TypeCode.CHAR) {
                this.populateCharArray(expressionState, object2, typeConverter, inlineList);
            } else if (typeCode == TypeCode.DOUBLE) {
                this.populateDoubleArray(expressionState, object2, typeConverter, inlineList);
            } else if (typeCode == TypeCode.FLOAT) {
                this.populateFloatArray(expressionState, object2, typeConverter, inlineList);
            } else if (typeCode == TypeCode.INT) {
                this.populateIntArray(expressionState, object2, typeConverter, inlineList);
            } else if (typeCode == TypeCode.LONG) {
                this.populateLongArray(expressionState, object2, typeConverter, inlineList);
            } else if (typeCode == TypeCode.SHORT) {
                this.populateShortArray(expressionState, object2, typeConverter, inlineList);
            } else {
                throw new IllegalStateException(typeCode.name());
            }
        }
        return new TypedValue(object2);
    }

    private void checkNumElements(long l2) {
        if (l2 >= 262144L) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MAX_ARRAY_ELEMENTS_THRESHOLD_EXCEEDED, 262144);
        }
    }

    private void populateReferenceTypeArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList, Class<?> clazz) {
        TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(clazz);
        Object[] objectArray = (Object[])object;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            SpelNode spelNode = inlineList.getChild(i2);
            Object object2 = spelNode.getValue(expressionState);
            objectArray[i2] = typeConverter.convertValue(object2, TypeDescriptor.forObject(object2), typeDescriptor);
        }
    }

    private void populateByteArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList) {
        byte[] byArray = (byte[])object;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            TypedValue typedValue = inlineList.getChild(i2).getTypedValue(expressionState);
            byArray[i2] = ExpressionUtils.toByte(typeConverter, typedValue);
        }
    }

    private void populateFloatArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList) {
        float[] fArray = (float[])object;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            TypedValue typedValue = inlineList.getChild(i2).getTypedValue(expressionState);
            fArray[i2] = ExpressionUtils.toFloat(typeConverter, typedValue);
        }
    }

    private void populateDoubleArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList) {
        double[] dArray = (double[])object;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            TypedValue typedValue = inlineList.getChild(i2).getTypedValue(expressionState);
            dArray[i2] = ExpressionUtils.toDouble(typeConverter, typedValue);
        }
    }

    private void populateShortArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList) {
        short[] sArray = (short[])object;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            TypedValue typedValue = inlineList.getChild(i2).getTypedValue(expressionState);
            sArray[i2] = ExpressionUtils.toShort(typeConverter, typedValue);
        }
    }

    private void populateLongArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList) {
        long[] lArray = (long[])object;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            TypedValue typedValue = inlineList.getChild(i2).getTypedValue(expressionState);
            lArray[i2] = ExpressionUtils.toLong(typeConverter, typedValue);
        }
    }

    private void populateCharArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList) {
        char[] cArray = (char[])object;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            TypedValue typedValue = inlineList.getChild(i2).getTypedValue(expressionState);
            cArray[i2] = ExpressionUtils.toChar(typeConverter, typedValue);
        }
    }

    private void populateBooleanArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList) {
        boolean[] blArray = (boolean[])object;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            TypedValue typedValue = inlineList.getChild(i2).getTypedValue(expressionState);
            blArray[i2] = ExpressionUtils.toBoolean(typeConverter, typedValue);
        }
    }

    private void populateIntArray(ExpressionState expressionState, Object object, TypeConverter typeConverter, InlineList inlineList) {
        int[] nArray = (int[])object;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TypedValue typedValue = inlineList.getChild(i2).getTypedValue(expressionState);
            nArray[i2] = ExpressionUtils.toInt(typeConverter, typedValue);
        }
    }

    private boolean hasInitializer() {
        return this.getChildCount() > 1;
    }

    @Override
    public boolean isCompilable() {
        ReflectiveConstructorExecutor reflectiveConstructorExecutor;
        if (!(this.cachedExecutor instanceof ReflectiveConstructorExecutor) || this.exitTypeDescriptor == null) {
            return false;
        }
        if (this.getChildCount() > 1) {
            int n2 = this.getChildCount();
            for (int i2 = 1; i2 < n2; ++i2) {
                if (this.children[i2].isCompilable()) continue;
                return false;
            }
        }
        if ((reflectiveConstructorExecutor = (ReflectiveConstructorExecutor)this.cachedExecutor) == null) {
            return false;
        }
        Constructor<?> constructor = reflectiveConstructorExecutor.getConstructor();
        return Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers());
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        ReflectiveConstructorExecutor reflectiveConstructorExecutor = (ReflectiveConstructorExecutor)this.cachedExecutor;
        Assert.state(reflectiveConstructorExecutor != null, "No cached executor");
        Constructor<?> constructor = reflectiveConstructorExecutor.getConstructor();
        String string = constructor.getDeclaringClass().getName().replace('.', '/');
        methodVisitor.visitTypeInsn(187, string);
        methodVisitor.visitInsn(89);
        SpelNodeImpl[] spelNodeImplArray = new SpelNodeImpl[this.children.length - 1];
        System.arraycopy(this.children, 1, spelNodeImplArray, 0, this.children.length - 1);
        ConstructorReference.generateCodeForArguments(methodVisitor, codeFlow, constructor, spelNodeImplArray);
        methodVisitor.visitMethodInsn(183, string, "<init>", CodeFlow.createSignatureDescriptor(constructor), false);
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

