/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.JdkZipEntry;
import org.gradle.api.internal.file.archive.impl.StreamZipInput;
import org.gradle.internal.file.FileException;

public class FileZipInput
implements ZipInput {
    private final ZipFile file;
    private final Enumeration<? extends java.util.zip.ZipEntry> entries;

    public static ZipInput create(File file) throws FileException {
        if (FileZipInput.isZipFileSafeToUse()) {
            return new FileZipInput(file);
        }
        try {
            return new StreamZipInput(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileException(fileNotFoundException);
        }
    }

    private static boolean isZipFileSafeToUse() {
        String string = System.getProperty("java.specification.version");
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Could not determine java version from '" + string + "'.");
        }
        return Integer.parseInt(stringArray[0]) >= 11;
    }

    private FileZipInput(File file) {
        try {
            this.file = new ZipFile(file);
        }
        catch (IOException iOException) {
            throw new FileException(iOException);
        }
        this.entries = this.file.entries();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            @Override
            protected ZipEntry computeNext() {
                if (!FileZipInput.this.entries.hasMoreElements()) {
                    return (ZipEntry)this.endOfData();
                }
                final java.util.zip.ZipEntry zipEntry = (java.util.zip.ZipEntry)FileZipInput.this.entries.nextElement();
                return new JdkZipEntry(zipEntry, new Supplier<InputStream>(){

                    @Override
                    public InputStream get() {
                        try {
                            return FileZipInput.this.file.getInputStream(zipEntry);
                        }
                        catch (IOException iOException) {
                            throw new FileException(iOException);
                        }
                    }
                }, null);
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

