/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Output;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;

public class CollectionSerializer
extends Serializer<Collection> {
    private boolean elementsCanBeNull = true;
    private Serializer serializer;
    private Class elementClass;
    private Class genericType;

    public void setElementsCanBeNull(boolean bl2) {
        this.elementsCanBeNull = bl2;
    }

    public void setElementClass(Class clazz, Serializer serializer) {
        this.elementClass = clazz;
        this.serializer = serializer;
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] classArray) {
        this.genericType = null;
        if (classArray != null && classArray.length > 0 && kryo.isFinal(classArray[0])) {
            this.genericType = classArray[0];
        }
    }

    @Override
    public void write(Kryo kryo, Output output, Collection collection) {
        int n2 = collection.size();
        output.writeVarInt(n2, true);
        Serializer serializer = this.serializer;
        if (this.genericType != null) {
            if (serializer == null) {
                serializer = kryo.getSerializer(this.genericType);
            }
            this.genericType = null;
        }
        if (serializer != null) {
            if (this.elementsCanBeNull) {
                for (Object e2 : collection) {
                    kryo.writeObjectOrNull(output, e2, serializer);
                }
            } else {
                for (Object e3 : collection) {
                    kryo.writeObject(output, e3, serializer);
                }
            }
        } else {
            for (Object e4 : collection) {
                kryo.writeClassAndObject(output, e4);
            }
        }
    }

    protected Collection create(Kryo kryo, Input input, Class<Collection> clazz) {
        return kryo.newInstance(clazz);
    }

    @Override
    public Collection read(Kryo kryo, Input input, Class<Collection> clazz) {
        Collection collection = this.create(kryo, input, clazz);
        kryo.reference(collection);
        int n2 = input.readVarInt(true);
        if (collection instanceof ArrayList) {
            ((ArrayList)collection).ensureCapacity(n2);
        }
        Class clazz2 = this.elementClass;
        Serializer serializer = this.serializer;
        if (this.genericType != null) {
            if (serializer == null) {
                clazz2 = this.genericType;
                serializer = kryo.getSerializer(this.genericType);
            }
            this.genericType = null;
        }
        if (serializer != null) {
            if (this.elementsCanBeNull) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    collection.add(kryo.readObjectOrNull(input, clazz2, serializer));
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    collection.add(kryo.readObject(input, clazz2, serializer));
                }
            }
        } else {
            for (int i4 = 0; i4 < n2; ++i4) {
                collection.add(kryo.readClassAndObject(input));
            }
        }
        return collection;
    }

    protected Collection createCopy(Kryo kryo, Collection collection) {
        return (Collection)kryo.newInstance(collection.getClass());
    }

    @Override
    public Collection copy(Kryo kryo, Collection collection) {
        Collection collection2 = this.createCopy(kryo, collection);
        kryo.reference(collection2);
        for (Object e2 : collection) {
            collection2.add(kryo.copy(e2));
        }
        return collection2;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BindCollection {
        public Class<? extends Serializer> elementSerializer() default Serializer.class;

        public Class<?> elementClass() default Object.class;

        public boolean elementsCanBeNull() default true;
    }
}

