/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DatabindContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.InjectableValues;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.Annotated;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.LinkedNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ObjectBuffer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DeserializationContext
extends DatabindContext
implements Serializable {
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final JacksonFeatureSet<StreamReadCapability> _readCapabilities;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;
    protected transient ContextAttributes _attributes;
    protected LinkedNode<JavaType> _currentType;

    protected DeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        if (deserializerFactory == null) {
            throw new NullPointerException("Cannot pass null DeserializerFactory");
        }
        this._factory = deserializerFactory;
        if (deserializerCache == null) {
            deserializerCache = new DeserializerCache();
        }
        this._cache = deserializerCache;
        this._featureFlags = 0;
        this._readCapabilities = null;
        this._config = null;
        this._injectableValues = null;
        this._view = null;
        this._attributes = null;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory) {
        this._cache = deserializationContext._cache;
        this._factory = deserializerFactory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._readCapabilities = deserializationContext._readCapabilities;
        this._view = deserializationContext._view;
        this._parser = deserializationContext._parser;
        this._injectableValues = deserializationContext._injectableValues;
        this._attributes = deserializationContext._attributes;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        this._cache = deserializationContext._cache;
        this._factory = deserializationContext._factory;
        this._readCapabilities = jsonParser == null ? null : jsonParser.getReadCapabilities();
        this._config = deserializationConfig;
        this._featureFlags = deserializationConfig.getDeserializationFeatures();
        this._view = deserializationConfig.getActiveView();
        this._parser = jsonParser;
        this._injectableValues = injectableValues;
        this._attributes = deserializationConfig.getAttributes();
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializationConfig deserializationConfig) {
        this._cache = deserializationContext._cache;
        this._factory = deserializationContext._factory;
        this._readCapabilities = null;
        this._config = deserializationConfig;
        this._featureFlags = deserializationConfig.getDeserializationFeatures();
        this._view = null;
        this._parser = null;
        this._injectableValues = null;
        this._attributes = null;
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    public final Class<?> getActiveView() {
        return this._view;
    }

    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        return this._config.getDefaultPropertyFormat(clazz);
    }

    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) throws IllegalArgumentException {
        if (javaType.hasRawClass(clazz)) {
            return javaType;
        }
        return this.getConfig().getTypeFactory().constructSpecializedType(javaType, clazz, false);
    }

    public Locale getLocale() {
        return this._config.getLocale();
    }

    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._featureFlags & deserializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(StreamReadCapability streamReadCapability) {
        return this._readCapabilities.isEnabled(streamReadCapability);
    }

    public final int getDeserializationFeatures() {
        return this._featureFlags;
    }

    public final boolean hasSomeOfFeatures(int n2) {
        return (this._featureFlags & n2) != 0;
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object object, BeanProperty beanProperty, Object object2) throws JsonMappingException {
        if (this._injectableValues == null) {
            return this.reportBadDefinition(ClassUtil.classOf(object), String.format("No 'injectableValues' configured, cannot inject value with id [%s]", object));
        }
        return this._injectableValues.findInjectableValue(object, this, beanProperty, object2);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public CoercionAction findCoercionAction(LogicalType logicalType, Class<?> clazz, CoercionInputShape coercionInputShape) {
        return this._config.findCoercionAction(logicalType, clazz, coercionInputShape);
    }

    public CoercionAction findCoercionFromBlankString(LogicalType logicalType, Class<?> clazz, CoercionAction coercionAction) {
        return this._config.findCoercionFromBlankString(logicalType, clazz, coercionAction);
    }

    public TokenBuffer bufferForInputBuffering(JsonParser jsonParser) {
        return new TokenBuffer(jsonParser, this);
    }

    public final TokenBuffer bufferForInputBuffering() {
        return this.bufferForInputBuffering(this.getParser());
    }

    public TokenBuffer bufferAsCopyOfValue(JsonParser jsonParser) throws IOException {
        TokenBuffer tokenBuffer = this.bufferForInputBuffering(jsonParser);
        tokenBuffer.copyCurrentStructure(jsonParser);
        return tokenBuffer;
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(this, this._factory, javaType);
        if (jsonDeserializer != null) {
            jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        }
        return jsonDeserializer;
    }

    public final JsonDeserializer<Object> findNonContextualValueDeserializer(JavaType javaType) throws JsonMappingException {
        return this._cache.findValueDeserializer(this, this._factory, javaType);
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(this, this._factory, javaType);
        if (jsonDeserializer == null) {
            return null;
        }
        jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, null, javaType);
        TypeDeserializer typeDeserializer = this._factory.findTypeDeserializer(this._config, javaType);
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(null);
            return new TypeWrappedDeserializer(typeDeserializer, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        KeyDeserializer keyDeserializer;
        try {
            keyDeserializer = this._cache.findKeyDeserializer(this, this._factory, javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportBadDefinition(javaType, ClassUtil.exceptionMessage(illegalArgumentException));
            keyDeserializer = null;
        }
        if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(this, beanProperty);
        }
        return keyDeserializer;
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2, ObjectIdResolver var3);

    public final JavaType constructType(Class<?> clazz) {
        return clazz == null ? null : this._config.constructType(clazz);
    }

    public Class<?> findClass(String string) throws ClassNotFoundException {
        return this.getTypeFactory().findClass(string);
    }

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer objectBuffer = this._objectBuffer;
        if (objectBuffer == null) {
            objectBuffer = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return objectBuffer;
    }

    public final void returnObjectBuffer(ObjectBuffer objectBuffer) {
        if (this._objectBuffer == null || objectBuffer.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = objectBuffer;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return jsonDeserializer;
    }

    public Date parseDate(String string) throws IllegalArgumentException {
        try {
            DateFormat dateFormat = this._getDateFormat();
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.format("Failed to parse Date value '%s': %s", string, ClassUtil.exceptionMessage(parseException)));
        }
    }

    public Calendar constructCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        return calendar;
    }

    public String extractScalarFromObject(JsonParser jsonParser, JsonDeserializer<?> jsonDeserializer, Class<?> clazz) throws IOException {
        return (String)this.handleUnexpectedToken(clazz, jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException {
        return this.readValue(jsonParser, this.getTypeFactory().constructType(clazz));
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            return this.reportBadDefinition(javaType, "Could not find JsonDeserializer for type " + ClassUtil.getTypeDescription(javaType));
        }
        return (T)jsonDeserializer.deserialize(jsonParser, this);
    }

    public boolean handleUnknownProperty(JsonParser jsonParser, JsonDeserializer<?> jsonDeserializer, Object object, String string) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            if (!linkedNode.value().handleUnknownProperty(this, jsonParser, jsonDeserializer, object, string)) continue;
            return true;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            jsonParser.skipChildren();
            return true;
        }
        Collection<Object> collection = jsonDeserializer == null ? null : jsonDeserializer.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, object, string, collection);
    }

    public Object handleWeirdKey(Class<?> clazz, String string, String string2, Object ... objectArray) throws IOException {
        string2 = this._format(string2, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdKey(this, clazz, string, string2);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object == null || clazz.isInstance(object)) {
                return object;
            }
            throw this.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.getClassDescription(object)));
        }
        throw this.weirdKeyException(clazz, string, string2);
    }

    public Object handleWeirdStringValue(Class<?> clazz, String string, String string2, Object ... objectArray) throws IOException {
        string2 = this._format(string2, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdStringValue(this, clazz, string, string2);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object)) {
                return object;
            }
            throw this.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.getClassDescription(object)));
        }
        throw this.weirdStringException(string, clazz, string2);
    }

    public Object handleWeirdNumberValue(Class<?> clazz, Number number, String string, Object ... objectArray) throws IOException {
        string = this._format(string, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdNumberValue(this, clazz, number, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object)) {
                return object;
            }
            throw this.weirdNumberException(number, clazz, this._format("DeserializationProblemHandler.handleWeirdNumberValue() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.getClassDescription(object)));
        }
        throw this.weirdNumberException(number, clazz, string);
    }

    public Object handleWeirdNativeValue(JavaType javaType, Object object, JsonParser jsonParser) throws IOException {
        Class<?> clazz = javaType.getRawClass();
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleWeirdNativeValue(this, javaType, object, jsonParser);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object2 == null || clazz.isInstance(object2)) {
                return object2;
            }
            throw JsonMappingException.from(jsonParser, this._format("DeserializationProblemHandler.handleWeirdNativeValue() for type %s returned value of type %s", ClassUtil.getClassDescription(javaType), ClassUtil.getClassDescription(object2)));
        }
        throw this.weirdNativeValueException(object, clazz);
    }

    public Object handleMissingInstantiator(Class<?> clazz, ValueInstantiator valueInstantiator, JsonParser jsonParser, String string, Object ... objectArray) throws IOException {
        if (jsonParser == null) {
            jsonParser = this.getParser();
        }
        string = this._format(string, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleMissingInstantiator(this, clazz, valueInstantiator, jsonParser, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object)) {
                return object;
            }
            this.reportBadDefinition(this.constructType(clazz), String.format("DeserializationProblemHandler.handleMissingInstantiator() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.getClassDescription(object)));
        }
        if (valueInstantiator == null) {
            string = String.format("Cannot construct instance of %s: %s", ClassUtil.nameOf(clazz), string);
            return this.reportBadDefinition(clazz, string);
        }
        if (!valueInstantiator.canInstantiate()) {
            string = String.format("Cannot construct instance of %s (no Creators, like default constructor, exist): %s", ClassUtil.nameOf(clazz), string);
            return this.reportBadDefinition(clazz, string);
        }
        string = String.format("Cannot construct instance of %s (although at least one Creator exists): %s", ClassUtil.nameOf(clazz), string);
        return this.reportInputMismatch(clazz, string, new Object[0]);
    }

    public Object handleInstantiationProblem(Class<?> clazz, Object object, Throwable throwable) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleInstantiationProblem(this, clazz, object, throwable);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object2)) {
                return object2;
            }
            this.reportBadDefinition(this.constructType(clazz), String.format("DeserializationProblemHandler.handleInstantiationProblem() for type %s returned value of type %s", ClassUtil.getClassDescription(clazz), ClassUtil.classNameOf(object2)));
        }
        ClassUtil.throwIfIOE(throwable);
        if (!this.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw this.instantiationException(clazz, throwable);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonParser jsonParser) throws IOException {
        return this.handleUnexpectedToken(this.constructType(clazz), jsonParser.currentToken(), jsonParser, null, new Object[0]);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonToken jsonToken, JsonParser jsonParser, String string, Object ... objectArray) throws IOException {
        return this.handleUnexpectedToken(this.constructType(clazz), jsonToken, jsonParser, string, objectArray);
    }

    public Object handleUnexpectedToken(JavaType javaType, JsonParser jsonParser) throws IOException {
        return this.handleUnexpectedToken(javaType, jsonParser.currentToken(), jsonParser, null, new Object[0]);
    }

    public Object handleUnexpectedToken(JavaType javaType, JsonToken jsonToken, JsonParser jsonParser, String string, Object ... objectArray) throws IOException {
        Object object;
        string = this._format(string, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            object = linkedNode.value().handleUnexpectedToken(this, javaType, jsonToken, jsonParser, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(javaType.getRawClass(), object)) {
                return object;
            }
            this.reportBadDefinition(javaType, String.format("DeserializationProblemHandler.handleUnexpectedToken() for type %s returned value of type %s", ClassUtil.getTypeDescription(javaType), ClassUtil.classNameOf(object)));
        }
        if (string == null) {
            object = ClassUtil.getTypeDescription(javaType);
            string = jsonToken == null ? String.format("Unexpected end-of-input when trying read value of type %s", object) : String.format("Cannot deserialize value of type %s from %s (token `JsonToken.%s`)", new Object[]{object, this._shapeForToken(jsonToken), jsonToken});
        }
        if (jsonToken != null && jsonToken.isScalarValue()) {
            jsonParser.getText();
        }
        this.reportInputMismatch(javaType, string, new Object[0]);
        return null;
    }

    public JavaType handleUnknownTypeId(JavaType javaType, String string, TypeIdResolver typeIdResolver, String string2) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleUnknownTypeId(this, javaType, string, typeIdResolver, string2);
            if (javaType2 == null) continue;
            if (javaType2.hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
                return javaType2;
            }
            throw this.invalidTypeIdException(javaType, string, "problem handler tried to resolve into non-subtype: " + ClassUtil.getTypeDescription(javaType2));
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
            return null;
        }
        throw this.invalidTypeIdException(javaType, string, string2);
    }

    public JavaType handleMissingTypeId(JavaType javaType, TypeIdResolver typeIdResolver, String string) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleMissingTypeId(this, javaType, typeIdResolver, string);
            if (javaType2 == null) continue;
            if (javaType2.hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
                return javaType2;
            }
            throw this.invalidTypeIdException(javaType, null, "problem handler tried to resolve into non-subtype: " + ClassUtil.getTypeDescription(javaType2));
        }
        throw this.missingTypeIdException(javaType, string);
    }

    public void handleBadMerge(JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        if (!this.isEnabled(MapperFeature.IGNORE_MERGE_FOR_UNMERGEABLE)) {
            JavaType javaType = this.constructType(jsonDeserializer.handledType());
            String string = String.format("Invalid configuration: values of type %s cannot be merged", ClassUtil.getTypeDescription(javaType));
            throw InvalidDefinitionException.from(this.getParser(), string, javaType);
        }
    }

    protected boolean _isCompatible(Class<?> clazz, Object object) {
        if (object == null || clazz.isInstance(object)) {
            return true;
        }
        return clazz.isPrimitive() && ClassUtil.wrapperType(clazz).isInstance(object);
    }

    public void reportWrongTokenException(JsonDeserializer<?> jsonDeserializer, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw this.wrongTokenException(this.getParser(), jsonDeserializer.handledType(), jsonToken, string);
    }

    public void reportWrongTokenException(JavaType javaType, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw this.wrongTokenException(this.getParser(), javaType, jsonToken, string);
    }

    public void reportWrongTokenException(Class<?> clazz, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw this.wrongTokenException(this.getParser(), clazz, jsonToken, string);
    }

    public <T> T reportUnresolvedObjectId(ObjectIdReader objectIdReader, Object object) throws JsonMappingException {
        String string = String.format("No Object Id found for an instance of %s, to assign to property '%s'", ClassUtil.classNameOf(object), objectIdReader.propertyName);
        return this.reportInputMismatch(objectIdReader.idProperty, string, new Object[0]);
    }

    public <T> T reportInputMismatch(JsonDeserializer<?> jsonDeserializer, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), jsonDeserializer.handledType(), string);
    }

    public <T> T reportInputMismatch(Class<?> clazz, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), clazz, string);
    }

    public <T> T reportInputMismatch(JavaType javaType, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), javaType, string);
    }

    public <T> T reportInputMismatch(BeanProperty beanProperty, String string, Object ... objectArray) throws JsonMappingException {
        AnnotatedMember annotatedMember;
        string = this._format(string, objectArray);
        JavaType javaType = beanProperty == null ? null : beanProperty.getType();
        MismatchedInputException mismatchedInputException = MismatchedInputException.from(this.getParser(), javaType, string);
        if (beanProperty != null && (annotatedMember = beanProperty.getMember()) != null) {
            mismatchedInputException.prependPath(annotatedMember.getDeclaringClass(), beanProperty.getName());
        }
        throw mismatchedInputException;
    }

    public <T> T reportPropertyInputMismatch(Class<?> clazz, String string, String string2, Object ... objectArray) throws JsonMappingException {
        string2 = this._format(string2, objectArray);
        MismatchedInputException mismatchedInputException = MismatchedInputException.from(this.getParser(), clazz, string2);
        if (string != null) {
            mismatchedInputException.prependPath(clazz, string);
        }
        throw mismatchedInputException;
    }

    public <T> T reportPropertyInputMismatch(JavaType javaType, String string, String string2, Object ... objectArray) throws JsonMappingException {
        return this.reportPropertyInputMismatch(javaType.getRawClass(), string, string2, objectArray);
    }

    public <T> T reportBadCoercion(JsonDeserializer<?> jsonDeserializer, Class<?> clazz, Object object, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        InvalidFormatException invalidFormatException = InvalidFormatException.from(this.getParser(), string, object, clazz);
        throw invalidFormatException;
    }

    public <T> T reportTrailingTokens(Class<?> clazz, JsonParser jsonParser, JsonToken jsonToken) throws JsonMappingException {
        throw MismatchedInputException.from(jsonParser, clazz, String.format("Trailing token (of type %s) found after value (bound as %s): not allowed as per `DeserializationFeature.FAIL_ON_TRAILING_TOKENS`", new Object[]{jsonToken, ClassUtil.nameOf(clazz)}));
    }

    public <T> T reportBadTypeDefinition(BeanDescription beanDescription, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        String string2 = ClassUtil.nameOf(beanDescription.getBeanClass());
        string = String.format("Invalid type definition for type %s: %s", string2, string);
        throw InvalidDefinitionException.from(this._parser, string, beanDescription, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        String string2 = ClassUtil.nameOf(beanPropertyDefinition);
        String string3 = ClassUtil.nameOf(beanDescription.getBeanClass());
        string = String.format("Invalid definition for property %s (of type %s): %s", string2, string3, string);
        throw InvalidDefinitionException.from(this._parser, string, beanDescription, beanPropertyDefinition);
    }

    @Override
    public <T> T reportBadDefinition(JavaType javaType, String string) throws JsonMappingException {
        throw InvalidDefinitionException.from(this._parser, string, javaType);
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, JavaType javaType, JsonToken jsonToken, String string) {
        String string2 = String.format("Unexpected token (%s), expected %s", new Object[]{jsonParser.currentToken(), jsonToken});
        string2 = this._colonConcat(string2, string);
        return MismatchedInputException.from(jsonParser, javaType, string2);
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, Class<?> clazz, JsonToken jsonToken, String string) {
        String string2 = String.format("Unexpected token (%s), expected %s", new Object[]{jsonParser.currentToken(), jsonToken});
        string2 = this._colonConcat(string2, string);
        return MismatchedInputException.from(jsonParser, clazz, string2);
    }

    public JsonMappingException weirdKeyException(Class<?> clazz, String string, String string2) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize Map key of type %s from String %s: %s", ClassUtil.nameOf(clazz), this._quotedString(string), string2), string, clazz);
    }

    public JsonMappingException weirdStringException(String string, Class<?> clazz, String string2) {
        String string3 = String.format("Cannot deserialize value of type %s from String %s: %s", ClassUtil.nameOf(clazz), this._quotedString(string), string2);
        return InvalidFormatException.from(this._parser, string3, string, clazz);
    }

    public JsonMappingException weirdNumberException(Number number, Class<?> clazz, String string) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from number %s: %s", ClassUtil.nameOf(clazz), String.valueOf(number), string), number, clazz);
    }

    public JsonMappingException weirdNativeValueException(Object object, Class<?> clazz) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from native value (`JsonToken.VALUE_EMBEDDED_OBJECT`) of type %s: incompatible types", ClassUtil.nameOf(clazz), ClassUtil.classNameOf(object)), object, clazz);
    }

    public JsonMappingException instantiationException(Class<?> clazz, Throwable throwable) {
        String string;
        if (throwable == null) {
            string = "N/A";
        } else {
            string = ClassUtil.exceptionMessage(throwable);
            if (string == null) {
                string = ClassUtil.nameOf(throwable.getClass());
            }
        }
        String string2 = String.format("Cannot construct instance of %s, problem: %s", ClassUtil.nameOf(clazz), string);
        return ValueInstantiationException.from(this._parser, string2, this.constructType(clazz), throwable);
    }

    @Override
    public JsonMappingException invalidTypeIdException(JavaType javaType, String string, String string2) {
        String string3 = String.format("Could not resolve type id '%s' as a subtype of %s", string, ClassUtil.getTypeDescription(javaType));
        return InvalidTypeIdException.from(this._parser, this._colonConcat(string3, string2), javaType, string);
    }

    public JsonMappingException missingTypeIdException(JavaType javaType, String string) {
        String string2 = String.format("Could not resolve subtype of %s", javaType);
        return InvalidTypeIdException.from(this._parser, this._colonConcat(string2, string), javaType, null);
    }

    protected DateFormat _getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat dateFormat = this._config.getDateFormat();
        this._dateFormat = dateFormat = (DateFormat)dateFormat.clone();
        return dateFormat;
    }

    protected String _shapeForToken(JsonToken jsonToken) {
        if (jsonToken != null) {
            switch (jsonToken) {
                case START_OBJECT: 
                case END_OBJECT: 
                case FIELD_NAME: {
                    return "Object value";
                }
                case START_ARRAY: 
                case END_ARRAY: {
                    return "Array value";
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: {
                    return "Boolean value";
                }
                case VALUE_EMBEDDED_OBJECT: {
                    return "Embedded Object";
                }
                case VALUE_NUMBER_FLOAT: {
                    return "Floating-point value";
                }
                case VALUE_NUMBER_INT: {
                    return "Integer value";
                }
                case VALUE_STRING: {
                    return "String value";
                }
                case VALUE_NULL: {
                    return "Null value";
                }
            }
            return "[Unavailable value]";
        }
        return "<end of input>";
    }
}

