/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.HashCode;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.HashFunction;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.Hasher;
import java.nio.charset.Charset;

abstract class AbstractHashFunction
implements HashFunction {
    AbstractHashFunction() {
    }

    @Override
    public HashCode hashString(CharSequence charSequence, Charset charset) {
        return this.newHasher().putString(charSequence, charset).hash();
    }

    @Override
    public HashCode hashBytes(byte[] byArray) {
        return this.hashBytes(byArray, 0, byArray.length);
    }

    public HashCode hashBytes(byte[] byArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        return this.newHasher(n3).putBytes(byArray, n2, n3).hash();
    }

    public Hasher newHasher(int n2) {
        Preconditions.checkArgument(n2 >= 0, "expectedInputSize must be >= 0 but was %s", n2);
        return this.newHasher();
    }
}

