/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.NullByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteBufferAccumulator
implements AutoCloseable {
    private final List<ByteBuffer> _buffers = new ArrayList<ByteBuffer>();
    private final ByteBufferPool _bufferPool;
    private final boolean _direct;

    public ByteBufferAccumulator() {
        this(null, false);
    }

    public ByteBufferAccumulator(ByteBufferPool byteBufferPool, boolean bl2) {
        this._bufferPool = byteBufferPool == null ? new NullByteBufferPool() : byteBufferPool;
        this._direct = bl2;
    }

    public int getLength() {
        int n2 = 0;
        for (ByteBuffer byteBuffer : this._buffers) {
            n2 = Math.addExact(n2, byteBuffer.remaining());
        }
        return n2;
    }

    public ByteBuffer ensureBuffer(int n2, int n3) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = this._buffers.isEmpty() ? BufferUtil.EMPTY_BUFFER : this._buffers.get(this._buffers.size() - 1);
        if (BufferUtil.space(byteBuffer) < n2) {
            byteBuffer = this._bufferPool.acquire(n3, this._direct);
            this._buffers.add(byteBuffer);
        }
        return byteBuffer;
    }

    public ByteBuffer takeByteBuffer() {
        if (this._buffers.size() == 1) {
            ByteBuffer byteBuffer = this._buffers.get(0);
            this._buffers.clear();
            return byteBuffer;
        }
        int n2 = this.getLength();
        ByteBuffer byteBuffer = this._bufferPool.acquire(n2, this._direct);
        BufferUtil.clearToFill(byteBuffer);
        for (ByteBuffer byteBuffer2 : this._buffers) {
            byteBuffer.put(byteBuffer2);
            this._bufferPool.release(byteBuffer2);
        }
        BufferUtil.flipToFlush(byteBuffer, 0);
        this._buffers.clear();
        return byteBuffer;
    }

    @Override
    public void close() {
        this._buffers.forEach(this._bufferPool::release);
        this._buffers.clear();
    }
}

