/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingCallback
extends Callback.Nested {
    private final AtomicInteger count;

    public CountingCallback(Callback callback, int n2) {
        super(callback);
        if (n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.count = new AtomicInteger(n2);
    }

    @Override
    public void succeeded() {
        int n2;
        do {
            if ((n2 = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(n2, n2 - 1));
        if (n2 == 1) {
            super.succeeded();
        }
    }

    @Override
    public void failed(Throwable throwable) {
        int n2;
        do {
            if ((n2 = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(n2, 0));
        super.failed(throwable);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

