/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.gradle.api.internal.changedetection.state.LineEndingNormalizingInputStreamHasher;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.io.IoSupplier;

public class LineEndingNormalizingResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final LineEndingNormalizingInputStreamHasher hasher;

    private LineEndingNormalizingResourceHasher(ResourceHasher resourceHasher) {
        this.delegate = resourceHasher;
        this.hasher = new LineEndingNormalizingInputStreamHasher();
    }

    public static ResourceHasher wrap(ResourceHasher resourceHasher, LineEndingSensitivity lineEndingSensitivity) {
        switch (lineEndingSensitivity) {
            case DEFAULT: {
                return resourceHasher;
            }
            case NORMALIZE_LINE_ENDINGS: {
                return new LineEndingNormalizingResourceHasher(resourceHasher);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext regularFileSnapshotContext) throws IOException {
        return this.hasher.hashContent(new File(regularFileSnapshotContext.getSnapshot().getAbsolutePath())).orElseGet(IoSupplier.wrap(() -> this.delegate.hash(regularFileSnapshotContext)));
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return this.hashContent(zipEntryContext).orElseGet(IoSupplier.wrap(() -> this.delegate.hash(zipEntryContext)));
    }

    private Optional<HashCode> hashContent(ZipEntryContext zipEntryContext) throws IOException {
        return zipEntryContext.getEntry().isDirectory() ? Optional.empty() : zipEntryContext.getEntry().withInputStream(this.hasher::hashContent);
    }
}

