/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InetAddresses {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<InetAddress> loopback = new ArrayList<InetAddress>();
    private List<InetAddress> remote = new ArrayList<InetAddress>();
    private List<NetworkInterface> multicastInterfaces = new ArrayList<NetworkInterface>();

    InetAddresses() throws SocketException {
        this.analyzeNetworkInterfaces();
        if (this.multicastInterfaces.isEmpty()) {
            this.useMulticastFallback();
        }
    }

    private void analyzeNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.analyzeNetworkInterface(enumeration.nextElement());
            }
        }
    }

    private void analyzeNetworkInterface(NetworkInterface networkInterface) {
        this.logger.debug("Adding IP addresses for network interface {}", (Object)networkInterface.getDisplayName());
        try {
            boolean bl2 = networkInterface.isLoopback();
            this.logger.debug("Is this a loopback interface? {}", (Object)bl2);
            boolean bl3 = networkInterface.supportsMulticast();
            this.logger.debug("Is this a multicast interface? {}", (Object)bl3);
            boolean bl4 = false;
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (bl2) {
                    if (inetAddress.isLoopbackAddress()) {
                        this.logger.debug("Adding loopback address {}", (Object)inetAddress);
                        this.loopback.add(inetAddress);
                        continue;
                    }
                    this.logger.debug("Ignoring remote address on loopback interface {}", (Object)inetAddress);
                    continue;
                }
                if (inetAddress.isLoopbackAddress()) {
                    this.logger.debug("Ignoring loopback address on remote interface {}", (Object)inetAddress);
                    continue;
                }
                this.logger.debug("Adding remote address {}", (Object)inetAddress);
                this.remote.add(inetAddress);
                bl4 = true;
            }
            if (bl3) {
                if (bl4) {
                    this.logger.debug("Adding remote multicast interface {}", (Object)networkInterface.getDisplayName());
                    this.multicastInterfaces.add(0, networkInterface);
                } else {
                    this.logger.debug("Adding loopback multicast interface {}", (Object)networkInterface.getDisplayName());
                    this.multicastInterfaces.add(networkInterface);
                }
            }
        }
        catch (SocketException socketException) {
            this.logger.debug("Error while querying interface {} for IP addresses", (Object)networkInterface, (Object)socketException);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(String.format("Could not determine the IP addresses for network interface %s", networkInterface.getName()), throwable);
        }
    }

    private void useMulticastFallback() throws SocketException {
        this.logger.debug("No multicast interfaces, using fallbacks");
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.multicastInterfaces.add(enumeration.nextElement());
            }
        }
    }

    public List<InetAddress> getLoopback() {
        return this.loopback;
    }

    public List<InetAddress> getRemote() {
        return this.remote;
    }
}

