/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDSubset;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDTypingNonValidator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDValidator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.ent.EntityDecl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxParsingException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputProblemReporter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidationContext;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.NotationDeclaration;

public final class DTDSubsetImpl
extends DTDSubset {
    final boolean mIsCachable;
    final boolean mFullyValidating;
    final boolean mHasNsDefaults;
    final HashMap<String, EntityDecl> mGeneralEntities;
    volatile transient List<EntityDecl> mGeneralEntityList = null;
    final Set<String> mRefdGEs;
    final HashMap<String, EntityDecl> mDefinedPEs;
    final Set<String> mRefdPEs;
    final HashMap<String, NotationDeclaration> mNotations;
    transient List<NotationDeclaration> mNotationList = null;
    final HashMap<PrefixedName, DTDElement> mElements;

    private DTDSubsetImpl(boolean bl2, HashMap<String, EntityDecl> hashMap, Set<String> set, HashMap<String, EntityDecl> hashMap2, Set<String> set2, HashMap<String, NotationDeclaration> hashMap3, HashMap<PrefixedName, DTDElement> hashMap4, boolean bl3) {
        this.mIsCachable = bl2;
        this.mGeneralEntities = hashMap;
        this.mRefdGEs = set;
        this.mDefinedPEs = hashMap2;
        this.mRefdPEs = set2;
        this.mNotations = hashMap3;
        this.mElements = hashMap4;
        this.mFullyValidating = bl3;
        boolean bl4 = false;
        if (hashMap4 != null) {
            for (DTDElement dTDElement : hashMap4.values()) {
                if (!dTDElement.hasNsDefaults()) continue;
                bl4 = true;
                break;
            }
        }
        this.mHasNsDefaults = bl4;
    }

    public static DTDSubsetImpl constructInstance(boolean bl2, HashMap<String, EntityDecl> hashMap, Set<String> set, HashMap<String, EntityDecl> hashMap2, Set<String> set2, HashMap<String, NotationDeclaration> hashMap3, HashMap<PrefixedName, DTDElement> hashMap4, boolean bl3) {
        return new DTDSubsetImpl(bl2, hashMap, set, hashMap2, set2, hashMap3, hashMap4, bl3);
    }

    @Override
    public DTDSubset combineWithExternalSubset(InputProblemReporter inputProblemReporter, DTDSubset dTDSubset) throws XMLStreamException {
        HashMap<String, EntityDecl> hashMap = this.getGeneralEntityMap();
        HashMap<String, EntityDecl> hashMap2 = dTDSubset.getGeneralEntityMap();
        if (hashMap == null || hashMap.isEmpty()) {
            hashMap = hashMap2;
        } else if (hashMap2 != null && !hashMap2.isEmpty()) {
            DTDSubsetImpl.combineMaps(hashMap, hashMap2);
        }
        HashMap<String, NotationDeclaration> hashMap3 = this.getNotationMap();
        HashMap<String, NotationDeclaration> hashMap4 = dTDSubset.getNotationMap();
        if (hashMap3 == null || hashMap3.isEmpty()) {
            hashMap3 = hashMap4;
        } else if (hashMap4 != null && !hashMap4.isEmpty()) {
            DTDSubsetImpl.checkNotations(hashMap3, hashMap4);
            DTDSubsetImpl.combineMaps(hashMap3, hashMap4);
        }
        HashMap<PrefixedName, DTDElement> hashMap5 = this.getElementMap();
        HashMap<PrefixedName, DTDElement> hashMap6 = dTDSubset.getElementMap();
        if (hashMap5 == null || hashMap5.isEmpty()) {
            hashMap5 = hashMap6;
        } else if (hashMap6 != null && !hashMap6.isEmpty()) {
            this.combineElements(inputProblemReporter, hashMap5, hashMap6);
        }
        return DTDSubsetImpl.constructInstance(false, hashMap, null, null, null, hashMap3, hashMap5, this.mFullyValidating);
    }

    @Override
    public XMLValidator createValidator(ValidationContext validationContext) throws XMLStreamException {
        if (this.mFullyValidating) {
            return new DTDValidator(this, validationContext, this.mHasNsDefaults, this.getElementMap(), this.getGeneralEntityMap());
        }
        return new DTDTypingNonValidator(this, validationContext, this.mHasNsDefaults, this.getElementMap(), this.getGeneralEntityMap());
    }

    @Override
    public int getEntityCount() {
        return this.mGeneralEntities == null ? 0 : this.mGeneralEntities.size();
    }

    @Override
    public int getNotationCount() {
        return this.mNotations == null ? 0 : this.mNotations.size();
    }

    @Override
    public boolean isCachable() {
        return this.mIsCachable;
    }

    @Override
    public HashMap<String, EntityDecl> getGeneralEntityMap() {
        return this.mGeneralEntities;
    }

    @Override
    public List<EntityDecl> getGeneralEntityList() {
        List<EntityDecl> list = this.mGeneralEntityList;
        if (list == null) {
            list = this.mGeneralEntities == null || this.mGeneralEntities.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<EntityDecl>(this.mGeneralEntities.values()));
            this.mGeneralEntityList = list;
        }
        return list;
    }

    @Override
    public HashMap<String, EntityDecl> getParameterEntityMap() {
        return this.mDefinedPEs;
    }

    @Override
    public HashMap<String, NotationDeclaration> getNotationMap() {
        return this.mNotations;
    }

    @Override
    public synchronized List<NotationDeclaration> getNotationList() {
        List<NotationDeclaration> list = this.mNotationList;
        if (list == null) {
            list = this.mNotations == null || this.mNotations.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<NotationDeclaration>(this.mNotations.values()));
            this.mNotationList = list;
        }
        return list;
    }

    @Override
    public HashMap<PrefixedName, DTDElement> getElementMap() {
        return this.mElements;
    }

    @Override
    public boolean isReusableWith(DTDSubset dTDSubset) {
        HashMap<String, EntityDecl> hashMap;
        Set<String> set;
        Set<String> set2 = this.mRefdPEs;
        if (set2 != null && set2.size() > 0 && (set = dTDSubset.getParameterEntityMap()) != null && ((HashMap)((Object)set)).size() > 0 && DataUtil.anyValuesInCommon(set2, ((HashMap)((Object)set)).keySet())) {
            return false;
        }
        set = this.mRefdGEs;
        return set == null || set.size() <= 0 || (hashMap = dTDSubset.getGeneralEntityMap()) == null || hashMap.size() <= 0 || !DataUtil.anyValuesInCommon(set, hashMap.keySet());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[DTDSubset: ");
        int n2 = this.getEntityCount();
        stringBuilder.append(n2);
        stringBuilder.append(" general entities");
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static void throwNotationException(NotationDeclaration notationDeclaration, NotationDeclaration notationDeclaration2) throws XMLStreamException {
        throw new WstxParsingException(MessageFormat.format(ErrorConsts.ERR_DTD_NOTATION_REDEFD, notationDeclaration2.getName(), notationDeclaration.getLocation().toString()), notationDeclaration2.getLocation());
    }

    public static void throwElementException(DTDElement dTDElement, Location location) throws XMLStreamException {
        throw new WstxParsingException(MessageFormat.format(ErrorConsts.ERR_DTD_ELEM_REDEFD, dTDElement.getDisplayName(), dTDElement.getLocation().toString()), location);
    }

    private static <K, V> void combineMaps(Map<K, V> map, Map<K, V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            K k2 = entry.getKey();
            V v2 = map.put(k2, entry.getValue());
            if (v2 == null) continue;
            map.put(k2, v2);
        }
    }

    private void combineElements(InputProblemReporter inputProblemReporter, HashMap<PrefixedName, DTDElement> hashMap, HashMap<PrefixedName, DTDElement> hashMap2) throws XMLStreamException {
        for (Map.Entry<PrefixedName, DTDElement> entry : hashMap2.entrySet()) {
            PrefixedName prefixedName = entry.getKey();
            DTDElement dTDElement = entry.getValue();
            DTDElement dTDElement2 = hashMap.get(prefixedName);
            if (dTDElement2 == null) {
                hashMap.put(prefixedName, dTDElement);
                continue;
            }
            if (dTDElement.isDefined()) {
                if (dTDElement2.isDefined()) {
                    DTDSubsetImpl.throwElementException(dTDElement2, dTDElement.getLocation());
                    continue;
                }
                dTDElement2.defineFrom(inputProblemReporter, dTDElement, this.mFullyValidating);
                continue;
            }
            if (!dTDElement2.isDefined()) {
                inputProblemReporter.reportProblem(dTDElement2.getLocation(), ErrorConsts.WT_ENT_DECL, ErrorConsts.W_UNDEFINED_ELEM, dTDElement.getDisplayName(), null);
                continue;
            }
            dTDElement2.mergeMissingAttributesFrom(inputProblemReporter, dTDElement, this.mFullyValidating);
        }
    }

    private static void checkNotations(HashMap<String, NotationDeclaration> hashMap, HashMap<String, NotationDeclaration> hashMap2) throws XMLStreamException {
        for (Map.Entry<String, NotationDeclaration> entry : hashMap2.entrySet()) {
            if (!hashMap.containsKey(entry.getKey())) continue;
            DTDSubsetImpl.throwNotationException(hashMap.get(entry.getKey()), entry.getValue());
        }
    }
}

