/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import javax.xml.stream.Location;

public final class ElementId {
    private boolean mDefined;
    private final String mIdValue;
    private Location mLocation;
    private PrefixedName mElemName;
    private PrefixedName mAttrName;
    private ElementId mNextUndefined;
    private ElementId mNextColl;

    ElementId(String string, Location location, boolean bl2, PrefixedName prefixedName, PrefixedName prefixedName2) {
        this.mIdValue = string;
        this.mLocation = location;
        this.mDefined = bl2;
        this.mElemName = prefixedName;
        this.mAttrName = prefixedName2;
    }

    protected void linkUndefined(ElementId elementId) {
        if (this.mNextUndefined != null) {
            throw new IllegalStateException("ElementId '" + this + "' already had net undefined set ('" + this.mNextUndefined + "')");
        }
        this.mNextUndefined = elementId;
    }

    protected void setNextColliding(ElementId elementId) {
        this.mNextColl = elementId;
    }

    public String getId() {
        return this.mIdValue;
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public PrefixedName getElemName() {
        return this.mElemName;
    }

    public PrefixedName getAttrName() {
        return this.mAttrName;
    }

    public boolean isDefined() {
        return this.mDefined;
    }

    public boolean idMatches(char[] cArray, int n2, int n3) {
        if (this.mIdValue.length() != n3) {
            return false;
        }
        if (cArray[n2] != this.mIdValue.charAt(0)) {
            return false;
        }
        int n4 = 1;
        n3 += n2;
        while (++n2 < n3) {
            if (cArray[n2] != this.mIdValue.charAt(n4)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public boolean idMatches(String string) {
        return this.mIdValue.equals(string);
    }

    public ElementId nextUndefined() {
        return this.mNextUndefined;
    }

    public ElementId nextColliding() {
        return this.mNextColl;
    }

    public void markDefined(Location location) {
        if (this.mDefined) {
            throw new IllegalStateException(ErrorConsts.ERR_INTERNAL);
        }
        this.mDefined = true;
        this.mLocation = location;
    }

    public String toString() {
        return this.mIdValue;
    }
}

