/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;

public class ByteOrderMark
implements Serializable {
    public static final ByteOrderMark UTF_8 = new ByteOrderMark(StandardCharsets.UTF_8.name(), 239, 187, 191);
    public static final ByteOrderMark UTF_16BE = new ByteOrderMark(StandardCharsets.UTF_16BE.name(), 254, 255);
    public static final ByteOrderMark UTF_16LE = new ByteOrderMark(StandardCharsets.UTF_16LE.name(), 255, 254);
    public static final ByteOrderMark UTF_32BE = new ByteOrderMark("UTF-32BE", 0, 0, 254, 255);
    public static final ByteOrderMark UTF_32LE = new ByteOrderMark("UTF-32LE", 255, 254, 0, 0);
    private final String charsetName;
    private final int[] bytes;

    public ByteOrderMark(String string, int ... nArray) {
        Objects.requireNonNull(string, "charsetName");
        Objects.requireNonNull(nArray, "bytes");
        if (string.isEmpty()) {
            throw new IllegalArgumentException("No charsetName specified");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("No bytes specified");
        }
        this.charsetName = string;
        this.bytes = (int[])nArray.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteOrderMark)) {
            return false;
        }
        ByteOrderMark byteOrderMark = (ByteOrderMark)object;
        if (this.bytes.length != byteOrderMark.length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.bytes.length; ++i2) {
            if (this.bytes[i2] == byteOrderMark.get(i2)) continue;
            return false;
        }
        return true;
    }

    public int get(int n2) {
        return this.bytes[n2];
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public int hashCode() {
        int n2 = this.getClass().hashCode();
        for (int n3 : this.bytes) {
            n2 += n3;
        }
        return n2;
    }

    public int length() {
        return this.bytes.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('[');
        stringBuilder.append(this.charsetName);
        stringBuilder.append(": ");
        for (int i2 = 0; i2 < this.bytes.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("0x");
            stringBuilder.append(Integer.toHexString(0xFF & this.bytes[i2]).toUpperCase(Locale.ROOT));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

