/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.command;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Map;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultBuildCacheCommandFactory
implements BuildCacheCommandFactory {
    private final BuildCacheEntryPacker packer;
    private final OriginMetadataFactory originMetadataFactory;
    private final FileSystemAccess fileSystemAccess;
    private final Interner<String> stringInterner;

    public DefaultBuildCacheCommandFactory(BuildCacheEntryPacker buildCacheEntryPacker, OriginMetadataFactory originMetadataFactory, FileSystemAccess fileSystemAccess, Interner<String> interner) {
        this.packer = buildCacheEntryPacker;
        this.originMetadataFactory = originMetadataFactory;
        this.fileSystemAccess = fileSystemAccess;
        this.stringInterner = interner;
    }

    @Override
    public BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> createLoad(BuildCacheKey buildCacheKey, CacheableEntity cacheableEntity) {
        return new LoadCommand(buildCacheKey, cacheableEntity);
    }

    @Override
    public BuildCacheStoreCommand createStore(BuildCacheKey buildCacheKey, CacheableEntity cacheableEntity, Map<String, ? extends FileSystemSnapshot> map, long l2) {
        return new StoreCommand(buildCacheKey, cacheableEntity, map, l2);
    }

    private class LoadCommand
    implements BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;

        private LoadCommand(BuildCacheKey buildCacheKey, CacheableEntity cacheableEntity) {
            this.cacheKey = buildCacheKey;
            this.entity = cacheableEntity;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata> load(InputStream inputStream) throws IOException {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.entity.visitOutputTrees((string, treeType, file) -> builder.add(file.getAbsolutePath()));
            DefaultBuildCacheCommandFactory.this.fileSystemAccess.write(builder.build(), () -> {});
            final BuildCacheEntryPacker.UnpackResult unpackResult = DefaultBuildCacheCommandFactory.this.packer.unpack(this.entity, inputStream, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createReader(this.entity));
            final ImmutableSortedMap<String, FileSystemSnapshot> immutableSortedMap = this.snapshotUnpackedData(unpackResult.getSnapshots());
            return new BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata>(){

                @Override
                public long getArtifactEntryCount() {
                    return unpackResult.getEntries();
                }

                @Override
                public BuildCacheCommandFactory.LoadMetadata getMetadata() {
                    return new BuildCacheCommandFactory.LoadMetadata(){

                        @Override
                        public OriginMetadata getOriginMetadata() {
                            return unpackResult.getOriginMetadata();
                        }

                        @Override
                        public ImmutableSortedMap<String, FileSystemSnapshot> getResultingSnapshots() {
                            return immutableSortedMap;
                        }
                    };
                }
            };
        }

        private ImmutableSortedMap<String, FileSystemSnapshot> snapshotUnpackedData(Map<String, ? extends FileSystemLocationSnapshot> map) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            this.entity.visitOutputTrees((string, treeType, file) -> {
                FileSystemLocationSnapshot fileSystemLocationSnapshot;
                FileSystemLocationSnapshot fileSystemLocationSnapshot2 = (FileSystemLocationSnapshot)map.get(string);
                if (fileSystemLocationSnapshot2 == null) {
                    String string2 = DefaultBuildCacheCommandFactory.this.stringInterner.intern(file.getAbsolutePath());
                    fileSystemLocationSnapshot = new MissingFileSnapshot(string2, FileMetadata.AccessType.DIRECT);
                } else {
                    if (treeType == TreeType.FILE && fileSystemLocationSnapshot2.getType() != FileType.RegularFile) {
                        throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", new Object[]{string, fileSystemLocationSnapshot2.getType()}));
                    }
                    fileSystemLocationSnapshot = fileSystemLocationSnapshot2;
                }
                DefaultBuildCacheCommandFactory.this.fileSystemAccess.record(fileSystemLocationSnapshot);
                builder.put(string, fileSystemLocationSnapshot);
            });
            return builder.build();
        }
    }

    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;
        private final Map<String, ? extends FileSystemSnapshot> snapshots;
        private final long executionTime;

        private StoreCommand(BuildCacheKey buildCacheKey, CacheableEntity cacheableEntity, Map<String, ? extends FileSystemSnapshot> map, long l2) {
            this.cacheKey = buildCacheKey;
            this.entity = cacheableEntity;
            this.snapshots = map;
            this.executionTime = l2;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheStoreCommand.Result store(OutputStream outputStream) throws IOException {
            BuildCacheEntryPacker.PackResult packResult = DefaultBuildCacheCommandFactory.this.packer.pack(this.entity, this.snapshots, outputStream, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createWriter(this.entity, Duration.ofMillis(this.executionTime)));
            return packResult::getEntries;
        }
    }
}

