/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import java.util.Map;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;

public class DefaultCurrentFileCollectionFingerprint
implements CurrentFileCollectionFingerprint {
    private final Map<String, FileSystemLocationFingerprint> fingerprints;
    private final FingerprintHashingStrategy hashingStrategy;
    private final String identifier;
    private final FileSystemSnapshot roots;
    private final ImmutableMultimap<String, HashCode> rootHashes;
    private final HashCode strategyConfigurationHash;
    private HashCode hash;

    public static CurrentFileCollectionFingerprint from(FileSystemSnapshot fileSystemSnapshot, FingerprintingStrategy fingerprintingStrategy, FileCollectionFingerprint fileCollectionFingerprint) {
        if (fileSystemSnapshot == FileSystemSnapshot.EMPTY) {
            return fingerprintingStrategy.getEmptyFingerprint();
        }
        ImmutableMultimap<String, HashCode> immutableMultimap = SnapshotUtil.getRootHashes(fileSystemSnapshot);
        Map<String, FileSystemLocationFingerprint> map = fileCollectionFingerprint != null && fileCollectionFingerprint.wasCreatedWithStrategy(fingerprintingStrategy) && DefaultCurrentFileCollectionFingerprint.equalRootHashes(fileCollectionFingerprint.getRootHashes(), immutableMultimap) ? fileCollectionFingerprint.getFingerprints() : fingerprintingStrategy.collectFingerprints(fileSystemSnapshot);
        if (map.isEmpty()) {
            return fingerprintingStrategy.getEmptyFingerprint();
        }
        return new DefaultCurrentFileCollectionFingerprint(map, fileSystemSnapshot, immutableMultimap, fingerprintingStrategy);
    }

    private static boolean equalRootHashes(ImmutableMultimap<String, HashCode> immutableMultimap, ImmutableMultimap<String, HashCode> immutableMultimap2) {
        return Iterables.elementsEqual(immutableMultimap.entries(), immutableMultimap2.entries());
    }

    private DefaultCurrentFileCollectionFingerprint(Map<String, FileSystemLocationFingerprint> map, FileSystemSnapshot fileSystemSnapshot, ImmutableMultimap<String, HashCode> immutableMultimap, FingerprintingStrategy fingerprintingStrategy) {
        this.fingerprints = map;
        this.identifier = fingerprintingStrategy.getIdentifier();
        this.hashingStrategy = fingerprintingStrategy.getHashingStrategy();
        this.strategyConfigurationHash = fingerprintingStrategy.getConfigurationHash();
        this.roots = fileSystemSnapshot;
        this.rootHashes = immutableMultimap;
    }

    @Override
    public HashCode getHash() {
        if (this.hash == null) {
            Hasher hasher = Hashing.newHasher();
            this.hashingStrategy.appendToHasher(hasher, this.fingerprints.values());
            this.hash = hasher.hash();
        }
        return this.hash;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> getFingerprints() {
        return this.fingerprints;
    }

    @Override
    public ImmutableMultimap<String, HashCode> getRootHashes() {
        return this.rootHashes;
    }

    @Override
    public boolean wasCreatedWithStrategy(FingerprintingStrategy fingerprintingStrategy) {
        return fingerprintingStrategy.getConfigurationHash().equals(this.strategyConfigurationHash);
    }

    @Override
    public FileSystemSnapshot getSnapshot() {
        return this.roots;
    }

    public String toString() {
        return this.identifier + this.fingerprints;
    }
}

