/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.StringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.IDContextProvider2;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.DatatypeRef;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.REDocumentDeclaration;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.ResidualCalculator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.Token;
import java.util.StringTokenizer;

public class StringToken
extends Token {
    public final String literal;
    public final IDContextProvider2 context;
    protected final ResidualCalculator resCalc;
    protected final boolean ignorable;
    public DatatypeRef refType;
    protected boolean saturated = false;
    private static final Datatype[] ignoredType = new Datatype[0];

    public StringToken(REDocumentDeclaration rEDocumentDeclaration, String string, IDContextProvider2 iDContextProvider2) {
        this(rEDocumentDeclaration.resCalc, string, iDContextProvider2, null);
    }

    public StringToken(REDocumentDeclaration rEDocumentDeclaration, String string, IDContextProvider2 iDContextProvider2, DatatypeRef datatypeRef) {
        this(rEDocumentDeclaration.resCalc, string, iDContextProvider2, datatypeRef);
    }

    public StringToken(ResidualCalculator residualCalculator, String string, IDContextProvider2 iDContextProvider2, DatatypeRef datatypeRef) {
        this.resCalc = residualCalculator;
        this.literal = string;
        this.context = iDContextProvider2;
        this.refType = datatypeRef;
        boolean bl2 = this.ignorable = string.trim().length() == 0;
        if (this.ignorable && datatypeRef != null) {
            datatypeRef.types = ignoredType;
        }
    }

    public boolean match(DataExp dataExp) {
        if (!dataExp.dt.isValid(this.literal, this.context)) {
            return false;
        }
        if (dataExp.except != Expression.nullSet && this.resCalc.calcResidual(dataExp.except, this).isEpsilonReducible()) {
            return false;
        }
        if (this.refType != null) {
            this.assignType(dataExp.dt);
        }
        if (dataExp.dt.getIdType() != 0 && this.context != null) {
            this.context.onID(dataExp.dt, this);
        }
        return true;
    }

    public boolean match(ValueExp valueExp) {
        Object object = valueExp.dt.createValue(this.literal, this.context);
        if (!valueExp.dt.sameValue(object, valueExp.value)) {
            return false;
        }
        if (this.refType != null) {
            this.assignType(valueExp.dt);
        }
        if (valueExp.dt.getIdType() != 0 && this.context != null) {
            this.context.onID(valueExp.dt, this);
        }
        return true;
    }

    public boolean match(ListExp listExp) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.literal);
        Expression expression = listExp.exp;
        DatatypeRef datatypeRef = null;
        Datatype[] datatypeArray = null;
        int n2 = 0;
        if (this.refType != null) {
            datatypeRef = new DatatypeRef();
            datatypeArray = new Datatype[stringTokenizer.countTokens()];
        }
        while (stringTokenizer.hasMoreTokens()) {
            StringToken stringToken = this.createChildStringToken(stringTokenizer.nextToken(), datatypeRef);
            if ((expression = this.resCalc.calcResidual(expression, stringToken)) == Expression.nullSet) {
                return false;
            }
            if (datatypeRef == null) continue;
            if (datatypeRef.types == null) {
                this.saturated = true;
                this.refType.types = null;
                datatypeRef = null;
                continue;
            }
            if (datatypeRef.types.length != 1) {
                throw new Error();
            }
            datatypeArray[n2++] = datatypeRef.types[0];
        }
        if (!expression.isEpsilonReducible()) {
            return false;
        }
        if (datatypeArray != null) {
            this.refType.types = this.saturated ? null : datatypeArray;
            this.saturated = true;
        }
        return true;
    }

    protected StringToken createChildStringToken(String string, DatatypeRef datatypeRef) {
        return new StringToken(this.resCalc, string, this.context, datatypeRef);
    }

    public boolean matchAnyString() {
        if (this.refType != null) {
            this.assignType(StringType.theInstance);
        }
        return true;
    }

    private void assignType(Datatype datatype) {
        if (this.saturated) {
            if (this.refType.types != null && (this.refType.types[0] != datatype || this.refType.types.length != 1)) {
                this.refType.types = null;
            }
        } else {
            this.refType.types = new Datatype[]{datatype};
            this.saturated = true;
        }
    }

    boolean isIgnorable() {
        return this.ignorable;
    }
}

